/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.impl.source.jsp.jspJava.JspCodeBlock;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.java.ReplaceExpressionUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.ChainCallInplaceIntroducer;
import com.intellij.refactoring.introduceVariable.InputValidator;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.introduceVariable.JavaVariableInplaceIntroducer;
import com.intellij.refactoring.introduceVariable.ReassignVariableUtil;
import com.intellij.refactoring.introduceVariable.VariableExtractor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.refactoring.util.occurrences.NotInSuperCallOccurrenceFilter;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceVariableBase
extends IntroduceHandlerBase {
    private static final Logger LOG = Logger.getInstance(IntroduceVariableBase.class);
    @NonNls
    private static final String PREFER_STATEMENTS_OPTION = "introduce.variable.prefer.statements";
    @NonNls
    private static final String REFACTORING_ID = "refactoring.extractVariable";
    public static final Key<Boolean> NEED_PARENTHESIS = Key.create((String)"NEED_PARENTHESIS");
    private JavaVariableInplaceIntroducer myInplaceIntroducer;

    public static SuggestedNameInfo getSuggestedName(@Nullable PsiType type2, @NotNull PsiExpression expression2) {
        return IntroduceVariableBase.getSuggestedName(type2, expression2, (PsiElement)expression2);
    }

    public static SuggestedNameInfo getSuggestedName(@Nullable PsiType type2, @NotNull PsiExpression expression2, PsiElement anchor) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression2.getProject());
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, expression2, type2);
        String[] strings = JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, type2, VariableKind.LOCAL_VARIABLE, nameInfo);
        SuggestedNameInfo.Delegate delegate = new SuggestedNameInfo.Delegate(strings, nameInfo);
        return codeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)delegate, anchor, true);
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement[] statementsInRange = IntroduceVariableBase.findStatementsAtOffset(editor, file, offset);
            if (statementsInRange.length == 1 && IntroduceVariableBase.selectLineAtCaret(offset, statementsInRange)) {
                selectionModel.selectLineAtCaret();
                PsiExpression expressionInRange = IntroduceVariableBase.findExpressionInRange(project, file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
                if (expressionInRange == null || IntroduceVariableBase.getErrorMessage(expressionInRange) != null) {
                    selectionModel.removeSelection();
                }
            }
            if (!selectionModel.hasSelection()) {
                List expressions2 = ContainerUtil.filter(IntroduceVariableBase.collectExpressions(file, editor, offset), expression2 -> RefactoringUtil.getParentStatement((PsiElement)expression2, false) != null || PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiField.class, (boolean)true, (Class[])new Class[]{PsiStatement.class}) != null);
                if (expressions2.isEmpty()) {
                    selectionModel.selectLineAtCaret();
                } else if (!IntroduceVariableBase.isChooserNeeded(expressions2)) {
                    TextRange textRange = ((PsiExpression)expressions2.get(0)).getTextRange();
                    selectionModel.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                } else {
                    IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions2, (Pass)new Pass<PsiExpression>(){

                        public void pass(PsiExpression selectedValue) {
                            IntroduceVariableBase.this.invoke(project, editor, file, selectedValue.getTextRange().getStartOffset(), selectedValue.getTextRange().getEndOffset());
                        }
                    }, (com.intellij.util.Function)new PsiExpressionTrimRenderer.RenderFunction(), (String)RefactoringBundle.message((String)"introduce.target.chooser.expressions.title"), (int)IntroduceVariableBase.preferredSelection(statementsInRange, expressions2), (NotNullFunction)ScopeHighlighter.NATURAL_RANGER);
                    return;
                }
            }
        }
        if (this.invoke(project, editor, file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) && LookupManager.getActiveLookup((Editor)editor) == null) {
            selectionModel.removeSelection();
        }
    }

    public static boolean isChooserNeeded(List<? extends PsiExpression> expressions2) {
        if (expressions2.size() == 1) {
            PsiExpression expression2 = expressions2.get(0);
            return expression2 instanceof PsiNewExpression && ((PsiNewExpression)expression2).getAnonymousClass() != null;
        }
        return true;
    }

    public static boolean selectLineAtCaret(int offset, PsiElement[] statementsInRange) {
        TextRange range = statementsInRange[0].getTextRange();
        if (statementsInRange[0] instanceof PsiExpressionStatement) {
            range = ((PsiExpressionStatement)statementsInRange[0]).getExpression().getTextRange();
        }
        return range.getStartOffset() > offset || range.getEndOffset() <= offset || IntroduceVariableBase.isPreferStatements();
    }

    public static int preferredSelection(PsiElement[] statementsInRange, List<? extends PsiExpression> expressions2) {
        PsiExpression expression2;
        int selection = statementsInRange.length == 1 && statementsInRange[0] instanceof PsiExpressionStatement && PsiUtilCore.hasErrorElementChild((PsiElement)statementsInRange[0]) ? expressions2.indexOf(((PsiExpressionStatement)statementsInRange[0]).getExpression()) : ((expression2 = expressions2.get(0)) instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression2).resolve() instanceof PsiLocalVariable ? 1 : -1);
        return selection;
    }

    public static boolean isPreferStatements() {
        return Boolean.valueOf(PropertiesComponent.getInstance().getBoolean(PREFER_STATEMENTS_OPTION)) != false || Registry.is((String)PREFER_STATEMENTS_OPTION, (boolean)false);
    }

    public static List<PsiExpression> collectExpressions(PsiFile file, Editor editor, int offset) {
        return IntroduceVariableBase.collectExpressions(file, editor, offset, false);
    }

    public static List<PsiExpression> collectExpressions(PsiFile file, Editor editor, int offset, boolean acceptVoid) {
        return IntroduceVariableBase.collectExpressions(file, editor.getDocument(), offset, acceptVoid);
    }

    public static List<PsiExpression> collectExpressions(PsiFile file, Document document, int offset, boolean acceptVoid) {
        CharSequence text2 = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!Character.isJavaIdentifierPart(text2.charAt(offset))) {
            --correctedOffset;
        }
        if (correctedOffset < 0) {
            correctedOffset = offset;
        } else if (!Character.isJavaIdentifierPart(text2.charAt(correctedOffset))) {
            if (text2.charAt(correctedOffset) == ';') {
                --correctedOffset;
            }
            if (correctedOffset < 0 || text2.charAt(correctedOffset) != ')' && text2.charAt(correctedOffset) != '.') {
                correctedOffset = offset;
            }
        }
        PsiElement elementAtCaret = file.findElementAt(correctedOffset);
        ArrayList<PsiExpression> expressions2 = new ArrayList<PsiExpression>();
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PsiExpression.class);
        while (expression2 != null) {
            if (!(expressions2.contains(expression2) || expression2 instanceof PsiParenthesizedExpression || expression2 instanceof PsiSuperExpression || !acceptVoid && PsiType.VOID.equals((Object)expression2.getType()))) {
                if (expression2 instanceof PsiMethodReferenceExpression) {
                    expressions2.add(expression2);
                } else if (!(expression2 instanceof PsiAssignmentExpression)) {
                    PsiElement resolve2;
                    if (!(expression2 instanceof PsiReferenceExpression)) {
                        expressions2.add(expression2);
                    } else if (!(expression2.getParent() instanceof PsiMethodCallExpression || (resolve2 = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiClass || resolve2 instanceof PsiPackage)) {
                        expressions2.add(expression2);
                    }
                }
            }
            expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpression.class);
        }
        return expressions2;
    }

    public static PsiElement[] findStatementsAtOffset(Editor editor, PsiFile file, int offset) {
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(offset);
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        return CodeInsightUtil.findStatementsInRange(file, lineStart, lineEnd);
    }

    private boolean invoke(Project project, Editor editor, PsiFile file, int startOffset, int endOffset) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.introduceVariable");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        return this.invokeImpl(project, IntroduceVariableBase.findExpressionInRange(project, file, startOffset, endOffset), editor);
    }

    private static PsiExpression findExpressionInRange(Project project, PsiFile file, int startOffset, int endOffset) {
        PsiElement[] statements;
        PsiExpression tempExpr = CodeInsightUtil.findExpressionInRange(file, startOffset, endOffset);
        if (tempExpr == null && (statements = CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset)).length == 1) {
            if (statements[0] instanceof PsiExpressionStatement) {
                tempExpr = ((PsiExpressionStatement)statements[0]).getExpression();
            } else if (statements[0] instanceof PsiReturnStatement) {
                tempExpr = ((PsiReturnStatement)statements[0]).getReturnValue();
            } else if (statements[0] instanceof PsiSwitchStatement) {
                PsiExpression expr2 = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(statements[0].getText(), statements[0]);
                TextRange range = statements[0].getTextRange();
                RangeMarker rangeMarker = FileDocumentManager.getInstance().getDocument(file.getVirtualFile()).createRangeMarker(range);
                expr2.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)rangeMarker);
                expr2.putUserData(ElementToWorkOn.PARENT, (Object)statements[0]);
                return expr2;
            }
        }
        if (tempExpr == null) {
            tempExpr = IntroduceVariableBase.getSelectedExpression(project, file, startOffset, endOffset);
        }
        return tempExpr;
    }

    public static PsiExpression getSelectedExpression(Project project, PsiFile file, int startOffset, int endOffset) {
        PsiExpression tempExpr;
        PsiElement elementAtEnd;
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        PsiElement elementAtStart = file.findElementAt(startOffset);
        if (elementAtStart == null || elementAtStart instanceof PsiWhiteSpace || elementAtStart instanceof PsiComment) {
            PsiElement element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)elementAtStart);
            if (element != null) {
                startOffset = element.getTextOffset();
                elementAtStart = file.findElementAt(startOffset);
            }
            if (elementAtStart == null) {
                if (injectedLanguageManager.isInjectedFragment(file)) {
                    return IntroduceVariableBase.getSelectionFromInjectedHost(project, file, injectedLanguageManager, startOffset, endOffset);
                }
                return null;
            }
            startOffset = elementAtStart.getTextOffset();
        }
        if ((elementAtEnd = file.findElementAt(endOffset - 1)) == null || elementAtEnd instanceof PsiWhiteSpace || elementAtEnd instanceof PsiComment) {
            if ((elementAtEnd = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)elementAtEnd)) == null) {
                return null;
            }
            endOffset = elementAtEnd.getTextRange().getEndOffset();
        }
        if (endOffset <= startOffset) {
            return null;
        }
        PsiElement elementAt = PsiTreeUtil.findCommonParent((PsiElement)elementAtStart, (PsiElement)elementAtEnd);
        if (elementAt instanceof PsiExpressionStatement) {
            return ((PsiExpressionStatement)elementAt).getExpression();
        }
        PsiExpression containingExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiExpression.class, (boolean)false);
        if (containingExpression != null && containingExpression == elementAtEnd && startOffset == containingExpression.getTextOffset()) {
            return containingExpression;
        }
        if (containingExpression == null || containingExpression instanceof PsiLambdaExpression) {
            if (injectedLanguageManager.isInjectedFragment(file)) {
                return IntroduceVariableBase.getSelectionFromInjectedHost(project, file, injectedLanguageManager, startOffset, endOffset);
            }
            elementAt = null;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiLiteralExpression.class);
        PsiLiteralExpression startLiteralExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, PsiLiteralExpression.class);
        PsiLiteralExpression endLiteralExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(endOffset), PsiLiteralExpression.class);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        String text2 = null;
        try {
            PsiReferenceExpression refExpr;
            text2 = file.getText().subSequence(startOffset, endOffset).toString();
            String prefix = null;
            if (startLiteralExpression != null) {
                int startExpressionOffset = startLiteralExpression.getTextOffset();
                if (startOffset == startExpressionOffset + 1) {
                    text2 = "\"" + text2;
                } else if (startOffset > startExpressionOffset + 1) {
                    prefix = "\" + ";
                    text2 = "\"" + text2;
                }
            }
            String suffix = null;
            if (endLiteralExpression != null) {
                int endExpressionOffset = endLiteralExpression.getTextOffset() + endLiteralExpression.getTextLength();
                if (endOffset == endExpressionOffset - 1) {
                    text2 = text2 + "\"";
                } else if (endOffset < endExpressionOffset - 1) {
                    suffix = " + \"";
                    text2 = text2 + "\"";
                }
            }
            if (literalExpression != null && text2.equals(literalExpression.getText())) {
                return literalExpression;
            }
            Object parent = literalExpression != null ? literalExpression : elementAt;
            tempExpr = elementFactory.createExpressionFromText(text2, (PsiElement)parent);
            if (ErrorUtil.containsDeepError((PsiElement)tempExpr)) {
                return null;
            }
            tempExpr.putUserData(ElementToWorkOn.PREFIX, (Object)prefix);
            tempExpr.putUserData(ElementToWorkOn.SUFFIX, (Object)suffix);
            RangeMarker rangeMarker = FileDocumentManager.getInstance().getDocument(file.getVirtualFile()).createRangeMarker(startOffset, endOffset);
            tempExpr.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)rangeMarker);
            if (parent != null) {
                tempExpr.putUserData(ElementToWorkOn.PARENT, parent);
            } else {
                PsiErrorElement errorElement;
                PsiErrorElement psiErrorElement = errorElement = elementAtStart instanceof PsiErrorElement ? (PsiErrorElement)elementAtStart : (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)elementAtStart, PsiErrorElement.class);
                if (errorElement == null) {
                    errorElement = (PsiErrorElement)PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, PsiErrorElement.class);
                }
                if (errorElement == null) {
                    return null;
                }
                if (!(errorElement.getParent() instanceof PsiClass)) {
                    return null;
                }
                tempExpr.putUserData(ElementToWorkOn.PARENT, (Object)errorElement);
                tempExpr.putUserData(ElementToWorkOn.OUT_OF_CODE_BLOCK, (Object)Boolean.TRUE);
            }
            String fakeInitializer = "intellijidearulezzz";
            int[] refIdx = new int[1];
            PsiElement toBeExpression = IntroduceVariableBase.createReplacement("intellijidearulezzz", project, prefix, suffix, (PsiElement)parent, rangeMarker, refIdx);
            if (ErrorUtil.containsDeepError(toBeExpression)) {
                return null;
            }
            if (literalExpression != null && toBeExpression instanceof PsiExpression) {
                PsiType type2 = ((PsiExpression)toBeExpression).getType();
                if (type2 != null && !type2.equals(literalExpression.getType())) {
                    return null;
                }
            } else if (containingExpression != null) {
                PsiType containingExpressionType = containingExpression.getType();
                PsiType tempExprType = tempExpr.getType();
                if (!(containingExpressionType == null || tempExprType != null && TypeConversionUtil.isAssignable((PsiType)containingExpressionType, (PsiType)tempExprType))) {
                    return null;
                }
            }
            if ((refExpr = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)toBeExpression.findElementAt(refIdx[0]), PsiReferenceExpression.class)) == null) {
                return null;
            }
            if (toBeExpression == refExpr && refIdx[0] > 0) {
                return null;
            }
            if (ReplaceExpressionUtil.isNeedParenthesis(refExpr.getNode(), tempExpr.getNode())) {
                tempExpr.putCopyableUserData(NEED_PARENTHESIS, (Object)Boolean.TRUE);
                return tempExpr;
            }
        }
        catch (IncorrectOperationException e) {
            if (elementAt instanceof PsiExpressionList) {
                PsiElement parent = elementAt.getParent();
                return parent instanceof PsiCallExpression ? IntroduceVariableBase.createArrayCreationExpression(text2, startOffset, endOffset, (PsiCallExpression)parent) : null;
            }
            return null;
        }
        return tempExpr;
    }

    private static PsiExpression getSelectionFromInjectedHost(Project project, PsiFile file, InjectedLanguageManager injectedLanguageManager, int startOffset, int endOffset) {
        PsiLanguageInjectionHost injectionHost = injectedLanguageManager.getInjectionHost((PsiElement)file);
        return IntroduceVariableBase.getSelectedExpression(project, injectionHost.getContainingFile(), injectedLanguageManager.injectedToHost((PsiElement)file, startOffset), injectedLanguageManager.injectedToHost((PsiElement)file, endOffset));
    }

    @Nullable
    public static String getErrorMessage(PsiExpression expr2) {
        Boolean needParenthesis = (Boolean)expr2.getCopyableUserData(NEED_PARENTHESIS);
        if (needParenthesis != null && needParenthesis.booleanValue()) {
            return "Extracting selected expression would change the semantic of the whole expression.";
        }
        return null;
    }

    private static PsiExpression createArrayCreationExpression(String text2, int startOffset, int endOffset, PsiCallExpression parent) {
        if (text2 == null || parent == null) {
            return null;
        }
        if (text2.contains(",")) {
            PsiElement endElement;
            PsiElement startElement;
            PsiExpressionList argumentList = parent.getArgumentList();
            assert (argumentList != null);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)parent.getProject());
            JavaResolveResult resolveResult = parent.resolveMethodGenerics();
            PsiMethod psiMethod = (PsiMethod)resolveResult.getElement();
            if (psiMethod == null || !psiMethod.isVarArgs()) {
                return null;
            }
            PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
            PsiParameter varargParameter = parameters2[parameters2.length - 1];
            PsiType type2 = varargParameter.getType();
            LOG.assertTrue(type2 instanceof PsiEllipsisType);
            PsiArrayType psiType = (PsiArrayType)((PsiEllipsisType)type2).toArrayType();
            PsiExpression[] args = argumentList.getExpressions();
            PsiSubstitutor psiSubstitutor = resolveResult.getSubstitutor();
            if (args.length < parameters2.length || startOffset < args[parameters2.length - 1].getTextRange().getStartOffset()) {
                return null;
            }
            PsiFile containingFile = parent.getContainingFile();
            for (startElement = containingFile.findElementAt(startOffset); startElement != null && startElement.getParent() != argumentList; startElement = startElement.getParent()) {
            }
            if (!(startElement instanceof PsiExpression) || startOffset > startElement.getTextOffset()) {
                return null;
            }
            for (endElement = containingFile.findElementAt(endOffset - 1); endElement != null && endElement.getParent() != argumentList; endElement = endElement.getParent()) {
            }
            if (!(endElement instanceof PsiExpression) || endOffset < endElement.getTextRange().getEndOffset()) {
                return null;
            }
            PsiType componentType = TypeConversionUtil.erasure((PsiType)psiSubstitutor.substitute(psiType.getComponentType()));
            try {
                PsiExpression expressionFromText = elementFactory.createExpressionFromText("new " + componentType.getCanonicalText() + "[]{" + text2 + "}", (PsiElement)parent);
                RangeMarker rangeMarker = FileDocumentManager.getInstance().getDocument(containingFile.getVirtualFile()).createRangeMarker(startOffset, endOffset);
                expressionFromText.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)rangeMarker);
                expressionFromText.putUserData(ElementToWorkOn.PARENT, (Object)parent);
                return expressionFromText;
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected boolean invokeImpl(final Project project, final PsiExpression expr2, final Editor editor) {
        boolean isInplaceAvailableOnDataContext;
        String enumInSwitchError;
        String errorMessage;
        if (expr2 != null && (errorMessage = IntroduceVariableBase.getErrorMessage(expr2)) != null) {
            this.showErrorMessage(project, editor, RefactoringBundle.getCannotRefactorMessage((String)errorMessage));
            return false;
        }
        if (expr2 != null && expr2.getParent() instanceof PsiExpressionStatement) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.introduceVariable.incompleteStatement");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + expr2);
        }
        if (expr2 == null || !expr2.isPhysical()) {
            if (ReassignVariableUtil.reassign(editor)) {
                return false;
            }
            if (expr2 == null) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.block.should.represent.an.expression", (Object[])new Object[0]));
                this.showErrorMessage(project, editor, message2);
                return false;
            }
        }
        if ((enumInSwitchError = RefactoringUtil.checkEnumConstantInSwitchLabel(expr2)) != null) {
            this.showErrorMessage(project, editor, enumInSwitchError);
            return false;
        }
        final PsiType originalType = RefactoringUtil.getTypeByExpressionWithExpectedType(expr2);
        if (originalType == null || LambdaUtil.notInferredType((PsiType)originalType)) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"unknown.expression.type", (Object[])new Object[0]));
            this.showErrorMessage(project, editor, message3);
            return false;
        }
        if (PsiType.VOID.equals((Object)originalType)) {
            String message4 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.expression.has.void.type", (Object[])new Object[0]));
            this.showErrorMessage(project, editor, message4);
            return false;
        }
        for (PsiPatternVariable variable : JavaPsiPatternUtil.getExposedPatternVariables(expr2)) {
            if (!VariableAccessUtils.getVariableReferences((PsiVariable)variable, variable.getDeclarationScope()).stream().anyMatch(ref -> !PsiTreeUtil.isAncestor((PsiElement)expr2, (PsiElement)ref, (boolean)true))) continue;
            String message5 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.expression.introduces.pattern.variable", (Object[])new Object[]{variable.getName()}));
            this.showErrorMessage(project, editor, message5);
            return false;
        }
        final PsiElement anchorStatement = IntroduceVariableBase.getAnchor((PsiElement)expr2);
        PsiElement tempContainer = this.checkAnchorStatement(project, editor, anchorStatement);
        if (tempContainer == null) {
            return false;
        }
        final PsiFile file = anchorStatement.getContainingFile();
        LOG.assertTrue(file != null, (Object)"expr.getContainingFile() == null");
        PsiElement nameSuggestionContext = editor == null ? null : file.findElementAt(editor.getCaretModel().getOffset());
        RefactoringSupportProvider supportProvider = LanguageRefactoringSupport.INSTANCE.forContext((PsiElement)expr2);
        boolean bl = isInplaceAvailableOnDataContext = supportProvider != null && editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider.isInplaceIntroduceAvailable((PsiElement)expr2, nameSuggestionContext) && (!ApplicationManager.getApplication().isUnitTestMode() || this.isInplaceAvailableInTestMode()) && !IntroduceVariableBase.isInJspHolderMethod(expr2);
        if (isInplaceAvailableOnDataContext) {
            MultiMap conflicts = new MultiMap();
            IntroduceVariableBase.checkInLoopCondition(expr2, (MultiMap<PsiElement, String>)conflicts);
            if (!conflicts.isEmpty()) {
                this.showErrorMessage(project, editor, StringUtil.join((Collection)conflicts.values(), (String)"<br>"));
                return false;
            }
        }
        final ExpressionOccurrenceManager occurrenceManager = IntroduceVariableBase.createOccurrenceManager(expr2, tempContainer);
        final PsiExpression[] occurrences = occurrenceManager.getOccurrences();
        final OccurrencesInfo occurrencesInfo = new OccurrencesInfo(occurrences);
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return false;
        }
        LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> occurrencesMap = occurrencesInfo.buildOccurrencesMap(expr2);
        class IntroduceVariablePass
        extends Pass<JavaReplaceChoice> {
            boolean wasSucceed = true;

            IntroduceVariablePass() {
            }

            public void pass(JavaReplaceChoice choice) {
                if (choice == null || !IntroduceVariableBase.this.tryIntroduceInplace(project, editor, choice, occurrenceManager, originalType)) {
                    CommandProcessor.getInstance().executeCommand(project, () -> this.introduce(choice), IntroduceVariableBase.getRefactoringName(), null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void introduce(@Nullable JavaReplaceChoice choice) {
                PsiElement chosenAnchor;
                Object[] selectedOccurrences;
                IntroduceVariableSettings settings;
                PsiVariable variable;
                Editor topLevelEditor;
                block6: {
                    block5: {
                        if (!anchorStatement.isValid()) {
                            return;
                        }
                        topLevelEditor = !InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(anchorStatement.getContainingFile()) ? InjectedLanguageUtil.getTopLevelEditor((Editor)editor) : editor;
                        variable = null;
                        try {
                            boolean hasWriteAccess = occurrencesInfo.myHasWriteAccess;
                            InputValidator validator2 = new InputValidator(IntroduceVariableBase.this, project, occurrenceManager);
                            TypeSelectorManagerImpl typeSelectorManager = new TypeSelectorManagerImpl(project, originalType, expr2, occurrences);
                            boolean inFinalContext = occurrenceManager.isInFinalContext();
                            settings = IntroduceVariableBase.this.getSettings(project, topLevelEditor, expr2, occurrences, typeSelectorManager, inFinalContext, hasWriteAccess, validator2, anchorStatement, choice);
                            if (settings.isOK()) break block5;
                            this.wasSucceed = false;
                        }
                        catch (Throwable throwable) {
                            RefactoringEventData afterData = new RefactoringEventData();
                            afterData.addElement(variable);
                            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                            throw throwable;
                        }
                        RefactoringEventData afterData = new RefactoringEventData();
                        afterData.addElement(variable);
                        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                        return;
                    }
                    JavaReplaceChoice finalChoice = settings.getReplaceChoice();
                    selectedOccurrences = finalChoice.filter(occurrenceManager);
                    chosenAnchor = IntroduceVariableBase.getAnchor((PsiExpression[])selectedOccurrences);
                    if (chosenAnchor != null) break block6;
                    String text2 = file.getText();
                    String textWithOccurrences = ((EntryStream)StreamEx.of((Object[])selectedOccurrences).map(e -> IntroduceVariableBase.getPhysicalElement((PsiElement)e).getTextRange()).flatMapToEntry(range -> EntryStream.of((Object)range.getStartOffset(), (Object)"[", (Object)range.getEndOffset(), (Object)"]").toMap()).sortedBy(Map.Entry::getKey)).prepend((Object)0, (Object)"").append((Object)text2.length(), (Object)"").map(Function.identity()).pairMap((prev, next) -> text2.substring((Integer)prev.getKey(), (Integer)next.getKey()) + (String)next.getValue()).joining();
                    LOG.error("Unable to find anchor for a new variable; selectedOccurrences.length = " + selectedOccurrences.length, new Attachment[]{new Attachment("source.java", textWithOccurrences)});
                    RefactoringEventData afterData = new RefactoringEventData();
                    afterData.addElement((PsiElement)variable);
                    ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                    return;
                }
                RefactoringEventData beforeData = new RefactoringEventData();
                beforeData.addElement((PsiElement)expr2);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(IntroduceVariableBase.REFACTORING_ID, beforeData);
                variable = VariableExtractor.introduce(project, expr2, topLevelEditor, chosenAnchor, (PsiExpression[])selectedOccurrences, settings);
                RefactoringEventData afterData = new RefactoringEventData();
                afterData.addElement((PsiElement)variable);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
            }
        }
        IntroduceVariablePass callback = new IntroduceVariablePass();
        if (!isInplaceAvailableOnDataContext) {
            callback.pass(null);
        } else {
            String title = occurrencesInfo.myChainMethodName != null && occurrences.length == 1 ? JavaRefactoringBundle.message((String)"replace.lambda.chain.detected", (Object[])new Object[0]) : RefactoringBundle.message((String)"replace.multiple.occurrences.found");
            OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Pass)callback, occurrencesMap, title);
        }
        return callback.wasSucceed;
    }

    private boolean tryIntroduceInplace(@NotNull Project project, Editor editor, @NotNull JavaReplaceChoice choice, @NotNull ExpressionOccurrenceManager occurrenceManager, @NotNull PsiType originalType) {
        boolean inFinalContext = occurrenceManager.isInFinalContext();
        PsiExpression expr2 = occurrenceManager.getMainOccurence();
        Object[] selectedOccurrences = choice.filter(occurrenceManager);
        InputValidator validator2 = new InputValidator(this, project, occurrenceManager);
        TypeSelectorManagerImpl typeSelectorManager = new TypeSelectorManagerImpl(project, originalType, expr2, (PsiExpression[])selectedOccurrences);
        typeSelectorManager.setAllOccurrences(true);
        boolean hasWriteAccess = ContainerUtil.exists((Object[])selectedOccurrences, occ -> PsiUtil.isAccessedForWriting((PsiExpression)occ));
        PsiElement chosenAnchor = IntroduceVariableBase.getAnchor((PsiExpression[])selectedOccurrences);
        IntroduceVariableSettings settings = this.getSettings(project, editor, expr2, (PsiExpression[])selectedOccurrences, typeSelectorManager, inFinalContext, hasWriteAccess, validator2, chosenAnchor, choice);
        if (choice.isChain()) {
            this.myInplaceIntroducer = new ChainCallInplaceIntroducer(project, settings, chosenAnchor, editor, expr2, (PsiExpression[])selectedOccurrences, typeSelectorManager, IntroduceVariableBase.getRefactoringName());
        } else {
            boolean cantChangeFinalModifier = hasWriteAccess || inFinalContext;
            this.myInplaceIntroducer = new JavaVariableInplaceIntroducer(project, settings, chosenAnchor, editor, expr2, cantChangeFinalModifier, (PsiExpression[])selectedOccurrences, typeSelectorManager, IntroduceVariableBase.getRefactoringName());
        }
        return this.myInplaceIntroducer.startInplaceIntroduceTemplate();
    }

    public static boolean canBeExtractedWithoutExplicitType(PsiExpression expr2) {
        if (PsiUtil.isLanguageLevel10OrHigher((PsiElement)expr2)) {
            PsiType type2 = expr2.getType();
            return type2 != null && !PsiType.NULL.equals((Object)type2) && PsiTypesUtil.isDenotableType((PsiType)type2, (PsiElement)expr2) && (expr2 instanceof PsiNewExpression || type2.equals(((PsiExpression)expr2.copy()).getType()));
        }
        return false;
    }

    @Nullable
    private static PsiElement getAnchor(PsiElement place) {
        PsiField field;
        PsiElement anchorStatement = RefactoringUtil.getParentStatement(place = IntroduceVariableBase.getPhysicalElement(place), false);
        if (anchorStatement == null && (field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)place, PsiField.class, (boolean)true, (Class[])new Class[]{PsiStatement.class})) != null && !(field instanceof PsiEnumConstant)) {
            anchorStatement = field.getInitializer();
        }
        return anchorStatement;
    }

    @Nullable
    static PsiElement getAnchor(PsiExpression[] places) {
        if (places.length == 1) {
            return IntroduceVariableBase.getAnchor((PsiElement)places[0]);
        }
        PsiElement anchor = RefactoringUtil.getAnchorElementForMultipleExpressions(places, null);
        return anchor instanceof PsiField && !(anchor instanceof PsiEnumConstant) ? ((PsiField)anchor).getInitializer() : anchor;
    }

    @NotNull
    private static PsiElement getPhysicalElement(PsiElement place) {
        PsiElement physicalElement = (PsiElement)place.getUserData(ElementToWorkOn.PARENT);
        return physicalElement != null ? physicalElement : place;
    }

    @Contract(value="_, _, null -> null")
    protected PsiElement checkAnchorStatement(Project project, Editor editor, PsiElement anchorStatement) {
        if (anchorStatement == null) {
            String message2 = JavaRefactoringBundle.message((String)"refactoring.is.not.supported.in.the.current.context", (Object[])new Object[]{IntroduceVariableBase.getRefactoringName()});
            this.showErrorMessage(project, editor, message2);
            return null;
        }
        if (IntroduceVariableBase.checkAnchorBeforeThisOrSuper(project, editor, anchorStatement, IntroduceVariableBase.getRefactoringName(), "refactoring.introduceVariable")) {
            return null;
        }
        PsiElement tempContainer = anchorStatement.getParent();
        if (!(tempContainer instanceof PsiCodeBlock) && !RefactoringUtil.isLoopOrIf(tempContainer) && !(tempContainer instanceof PsiLambdaExpression) && tempContainer.getParent() instanceof PsiLambdaExpression) {
            String message3 = JavaRefactoringBundle.message((String)"refactoring.is.not.supported.in.the.current.context", (Object[])new Object[]{IntroduceVariableBase.getRefactoringName()});
            this.showErrorMessage(project, editor, message3);
            return null;
        }
        return tempContainer;
    }

    protected boolean isInplaceAvailableInTestMode() {
        return false;
    }

    private static ExpressionOccurrenceManager createOccurrenceManager(PsiExpression expr2, PsiElement tempContainer) {
        PsiClass containingClass;
        HashSet vars = new HashSet();
        ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)expr2)).filter(element -> element instanceof PsiReferenceExpression)).forEach(element -> {
            PsiElement resolve2 = ((PsiReferenceExpression)element).resolve();
            if (resolve2 instanceof PsiVariable) {
                vars.add((PsiVariable)resolve2);
            }
        });
        PsiElement containerParent = tempContainer;
        PsiElement lastScope = tempContainer;
        while (!(containerParent instanceof PsiFile) && (!(containerParent instanceof PsiMethod) || (containingClass = ((PsiMethod)containerParent).getContainingClass()) != null && PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass) && !vars.stream().anyMatch(variable -> PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)variable, (boolean)true)))) {
            if (containerParent instanceof PsiLambdaExpression) {
                PsiParameter[] parameters2 = ((PsiLambdaExpression)containerParent).getParameterList().getParameters();
                if (Arrays.stream(parameters2).anyMatch(vars::contains)) break;
            }
            if (containerParent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)containerParent;
                if (vars.stream().anyMatch(variable -> PsiTreeUtil.isAncestor((PsiElement)forStatement.getInitialization(), (PsiElement)variable, (boolean)true))) break;
            }
            if (!((containerParent = containerParent.getParent()) instanceof PsiCodeBlock)) continue;
            lastScope = containerParent;
        }
        return new ExpressionOccurrenceManager(expr2, lastScope, NotInSuperCallOccurrenceFilter.INSTANCE);
    }

    private static boolean isInJspHolderMethod(PsiExpression expr2) {
        PsiElement parent1 = expr2.getParent();
        if (parent1 == null) {
            return false;
        }
        PsiElement parent2 = parent1.getParent();
        if (!(parent2 instanceof JspCodeBlock)) {
            return false;
        }
        PsiElement parent3 = parent2.getParent();
        return parent3 instanceof JspHolderMethod;
    }

    static boolean isFinalVariableOnLHS(PsiExpression expr2) {
        PsiElement resolve2;
        return expr2 instanceof PsiReferenceExpression && RefactoringUtil.isAssignmentLHS((PsiElement)expr2) && (resolve2 = ((PsiReferenceExpression)expr2).resolve()) instanceof PsiVariable && ((PsiVariable)resolve2).hasModifierProperty("final");
    }

    public static PsiExpression simplifyVariableInitializer(PsiExpression initializer, PsiType expectedType) {
        return IntroduceVariableBase.simplifyVariableInitializer(initializer, expectedType, true);
    }

    public static PsiExpression simplifyVariableInitializer(PsiExpression initializer, PsiType expectedType, boolean inDeclaration) {
        if (initializer instanceof PsiTypeCastExpression) {
            PsiType operandType;
            PsiExpression operand2 = ((PsiTypeCastExpression)initializer).getOperand();
            if (operand2 != null && (operandType = operand2.getType()) != null && TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)operandType)) {
                return operand2;
            }
        } else if (initializer instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)initializer;
            if (newExpression.getArrayInitializer() != null) {
                if (inDeclaration) {
                    return newExpression.getArrayInitializer();
                }
            } else {
                PsiExpression tryToDetectDiamondNewExpr;
                PsiJavaCodeReferenceElement ref = newExpression.getClassOrAnonymousClassReference();
                if (ref != null && (tryToDetectDiamondNewExpr = ((PsiVariable)JavaPsiFacade.getElementFactory((Project)initializer.getProject()).createVariableDeclarationStatement("x", expectedType, initializer, (PsiElement)initializer).getDeclaredElements()[0]).getInitializer()) instanceof PsiNewExpression && PsiDiamondTypeUtil.canCollapseToDiamond((PsiNewExpression)tryToDetectDiamondNewExpr, (PsiNewExpression)tryToDetectDiamondNewExpr, expectedType)) {
                    PsiElement paramList = RemoveRedundantTypeArgumentsUtil.replaceExplicitWithDiamond((PsiElement)ref.getParameterList());
                    return (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)paramList, PsiNewExpression.class);
                }
            }
        }
        return initializer;
    }

    public static PsiElement expandDiamondsAndReplaceExplicitTypeWithVar(PsiTypeElement typeElement, PsiElement context) {
        PsiDiamondType.DiamondInferenceResult diamondResolveResult;
        PsiExpression copyVariableInitializer;
        PsiElement parent = typeElement.getParent();
        if (parent instanceof PsiVariable && (copyVariableInitializer = ((PsiVariable)parent).getInitializer()) instanceof PsiNewExpression && !(diamondResolveResult = PsiDiamondTypeImpl.resolveInferredTypesNoCheck((PsiNewExpression)copyVariableInitializer, (PsiElement)copyVariableInitializer)).getInferredTypes().isEmpty()) {
            PsiDiamondTypeUtil.expandTopLevelDiamondsInside(copyVariableInitializer);
        }
        return new CommentTracker().replaceAndRestoreComments((PsiElement)typeElement, (PsiElement)JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeElementFromText("var", context));
    }

    public static PsiElement replace(PsiExpression expr1, PsiExpression ref, Project project) throws IncorrectOperationException {
        Object expr2 = expr1 instanceof PsiArrayInitializerExpression && expr1.getParent() instanceof PsiNewExpression ? (PsiNewExpression)expr1.getParent() : RefactoringUtil.outermostParenthesizedExpression(expr1);
        if (expr2.isPhysical() || expr1.getUserData(ElementToWorkOn.REPLACE_NON_PHYSICAL) != null) {
            return expr2.replace((PsiElement)ref);
        }
        String prefix = (String)expr1.getUserData(ElementToWorkOn.PREFIX);
        String suffix = (String)expr1.getUserData(ElementToWorkOn.SUFFIX);
        PsiElement parent = (PsiElement)expr1.getUserData(ElementToWorkOn.PARENT);
        RangeMarker rangeMarker = (RangeMarker)expr1.getUserData(ElementToWorkOn.TEXT_RANGE);
        LOG.assertTrue(parent != null, (Object)expr1);
        return parent.replace(IntroduceVariableBase.createReplacement(ref.getText(), project, prefix, suffix, parent, rangeMarker, new int[1]));
    }

    private static PsiElement createReplacement(String refText, Project project, String prefix, String suffix, PsiElement parent, RangeMarker rangeMarker, int[] refIdx) {
        String text2 = refText;
        if (parent != null) {
            String allText = parent.getContainingFile().getText();
            TextRange parentRange = parent.getTextRange();
            LOG.assertTrue(parentRange.getStartOffset() <= rangeMarker.getStartOffset(), (Object)(parent + "; prefix:" + prefix + "; suffix:" + suffix));
            String beg = allText.substring(parentRange.getStartOffset(), rangeMarker.getStartOffset());
            if (StringUtil.stripQuotesAroundValue((String)beg).trim().isEmpty() && prefix == null) {
                beg = "";
            }
            LOG.assertTrue(rangeMarker.getEndOffset() <= parentRange.getEndOffset(), (Object)(parent + "; prefix:" + prefix + "; suffix:" + suffix));
            String end = allText.substring(rangeMarker.getEndOffset(), parentRange.getEndOffset());
            if (StringUtil.stripQuotesAroundValue((String)end).trim().isEmpty() && suffix == null) {
                end = "";
            }
            String start = beg + (prefix != null ? prefix : "");
            refIdx[0] = start.length();
            text2 = start + refText + (suffix != null ? suffix : "") + end;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        return parent instanceof PsiStatement ? factory.createStatementFromText(text2, parent) : (parent instanceof PsiCodeBlock ? factory.createCodeBlockFromText(text2, parent) : factory.createExpressionFromText(text2, parent));
    }

    @Override
    protected boolean invokeImpl(Project project, PsiLocalVariable localVariable, Editor editor) {
        throw new UnsupportedOperationException();
    }

    protected static void highlightReplacedOccurrences(Project project, Editor editor, PsiElement[] replacedOccurrences) {
        if (editor == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        highlightManager.addOccurrenceHighlights(editor, replacedOccurrences, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
        WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    protected abstract void showErrorMessage(Project var1, Editor var2, String var3);

    protected boolean reportConflicts(MultiMap<PsiElement, String> conflicts, Project project, IntroduceVariableSettings settings) {
        return false;
    }

    public IntroduceVariableSettings getSettings(Project project, Editor editor, PsiExpression expr2, PsiExpression[] occurrences, final TypeSelectorManagerImpl typeSelectorManager, boolean declareFinalIfAll, boolean anyAssignmentLHS, InputValidator validator2, PsiElement anchor, final JavaReplaceChoice replaceChoice) {
        final boolean replaceAll = replaceChoice.isAll();
        SuggestedNameInfo suggestedName = IntroduceVariableBase.getSuggestedName(typeSelectorManager.getDefaultType(), expr2, anchor);
        final String variableName2 = suggestedName.names.length > 0 ? suggestedName.names[0] : "v";
        final boolean declareFinal = replaceAll && declareFinalIfAll || !anyAssignmentLHS && IntroduceVariableBase.createFinals(anchor.getContainingFile()) || anchor instanceof PsiSwitchLabelStatementBase;
        final boolean declareVarType = IntroduceVariableBase.canBeExtractedWithoutExplicitType(expr2) && IntroduceVariableBase.createVarType() && !replaceChoice.isChain();
        final boolean replaceWrite = anyAssignmentLHS && replaceAll;
        return new IntroduceVariableSettings(){

            @Override
            public String getEnteredName() {
                return variableName2;
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return replaceAll;
            }

            @Override
            public boolean isDeclareFinal() {
                return declareFinal;
            }

            @Override
            public boolean isDeclareVarType() {
                return declareVarType;
            }

            @Override
            public boolean isReplaceLValues() {
                return replaceWrite;
            }

            @Override
            public PsiType getSelectedType() {
                PsiType selectedType = typeSelectorManager.getTypeSelector().getSelectedType();
                return selectedType != null ? selectedType : typeSelectorManager.getDefaultType();
            }

            @Override
            public JavaReplaceChoice getReplaceChoice() {
                return replaceChoice;
            }

            @Override
            public boolean isOK() {
                return true;
            }
        };
    }

    public static boolean createFinals(@NotNull PsiFile file) {
        Boolean createFinals = JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS;
        return createFinals == null ? JavaCodeStyleSettings.getInstance((PsiFile)file).GENERATE_FINAL_LOCALS : createFinals;
    }

    public static boolean createVarType() {
        Boolean createVarType = JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_VAR_TYPE;
        return createVarType != null && createVarType != false;
    }

    public static boolean checkAnchorBeforeThisOrSuper(Project project, Editor editor, PsiElement tempAnchorElement, String refactoringName, String helpID) {
        PsiMethod method;
        PsiExpression enclosingExpr;
        if (tempAnchorElement instanceof PsiExpressionStatement && (enclosingExpr = ((PsiExpressionStatement)tempAnchorElement).getExpression()) instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)enclosingExpr).resolveMethod()) != null && method.isConstructor()) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"invalid.expression.context", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)refactoringName, (String)helpID);
            return true;
        }
        return false;
    }

    public static void checkInLoopCondition(PsiExpression occurence, MultiMap<PsiElement, String> conflicts) {
        PsiElement loopForLoopCondition = RefactoringUtil.getLoopForLoopCondition(occurence);
        if (loopForLoopCondition == null || loopForLoopCondition instanceof PsiWhileStatement) {
            return;
        }
        List<PsiVariable> referencedVariables = RefactoringUtil.collectReferencedVariables((PsiElement)occurence);
        ArrayList<PsiVariable> modifiedInBody = new ArrayList<PsiVariable>();
        for (PsiVariable psiVariable : referencedVariables) {
            if (!RefactoringUtil.isModifiedInScope(psiVariable, loopForLoopCondition)) continue;
            modifiedInBody.add(psiVariable);
        }
        if (!modifiedInBody.isEmpty()) {
            for (PsiVariable variable : modifiedInBody) {
                String message2 = JavaRefactoringBundle.message((String)"is.modified.in.loop.body", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)variable, (boolean)false)});
                conflicts.putValue((Object)variable, (Object)CommonRefactoringUtil.capitalize((String)message2));
            }
            conflicts.putValue((Object)occurence, (Object)JavaRefactoringBundle.message((String)"introducing.variable.may.break.code.logic", (Object[])new Object[0]));
        }
    }

    @Override
    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroducer;
    }

    protected static String getRefactoringName() {
        return RefactoringBundle.message((String)"introduce.variable.title");
    }

    static class OccurrencesInfo {
        List<PsiExpression> myOccurrences;
        List<PsiExpression> myNonWrite;
        boolean myCantReplaceAll;
        boolean myCantReplaceAllButWrite;
        boolean myHasWriteAccess;
        final String myChainMethodName;

        OccurrencesInfo(PsiExpression[] occurrences) {
            this.myOccurrences = Arrays.asList(occurrences);
            this.myNonWrite = new ArrayList<PsiExpression>();
            this.myCantReplaceAll = false;
            this.myCantReplaceAllButWrite = false;
            for (PsiExpression occurrence : this.myOccurrences) {
                if (!RefactoringUtil.isAssignmentLHS((PsiElement)occurrence)) {
                    this.myNonWrite.add(occurrence);
                    continue;
                }
                if (IntroduceVariableBase.isFinalVariableOnLHS(occurrence)) {
                    this.myCantReplaceAll = true;
                    continue;
                }
                if (this.myNonWrite.isEmpty()) continue;
                this.myCantReplaceAllButWrite = true;
                this.myCantReplaceAll = true;
            }
            this.myHasWriteAccess = this.myOccurrences.size() > this.myNonWrite.size() && this.myOccurrences.size() > 1;
            this.myChainMethodName = this.getChainCallExtractor();
        }

        private String getChainCallExtractor() {
            if (this.myHasWriteAccess || this.myOccurrences.isEmpty()) {
                return null;
            }
            PsiExpression expression2 = this.myOccurrences.get(0);
            if (this.myOccurrences.size() == 1 && expression2.getParent() instanceof PsiLambdaExpression) {
                return null;
            }
            PsiElement parent = PsiTreeUtil.findCommonParent(this.myOccurrences);
            if (parent == null) {
                return null;
            }
            PsiType type2 = expression2.getType();
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            ChainCallExtractor extractor = ChainCallExtractor.findExtractor(lambda2, expression2, type2);
            if (extractor == null) {
                return null;
            }
            PsiParameter parameter2 = lambda2.getParameterList().getParameters()[0];
            if (!ReferencesSearch.search((PsiElement)parameter2).forEach(ref -> this.myOccurrences.stream().anyMatch(expr2 -> PsiTreeUtil.isAncestor((PsiElement)expr2, (PsiElement)ref.getElement(), (boolean)false)))) {
                return null;
            }
            return extractor.getMethodName((PsiVariable)parameter2, expression2, type2);
        }

        @NotNull
        LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> buildOccurrencesMap(PsiExpression expr2) {
            LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> occurrencesMap = new LinkedHashMap<JavaReplaceChoice, List<PsiExpression>>();
            if (this.myChainMethodName != null) {
                if (this.myOccurrences.size() > 1 && !this.myCantReplaceAll) {
                    occurrencesMap.put(JavaReplaceChoice.NO, Collections.singletonList(expr2));
                    occurrencesMap.put(JavaReplaceChoice.ALL, this.myOccurrences);
                    occurrencesMap.put(new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.ALL, null, true){

                        @Override
                        public String formatDescription(int occurrencesCount) {
                            return JavaRefactoringBundle.message((String)"replace.all.and.extract", (Object[])new Object[]{occurrencesCount, myChainMethodName});
                        }
                    }, this.myOccurrences);
                } else {
                    JavaReplaceChoice noChain = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.NO, JavaRefactoringBundle.message((String)"replace.inside.current.lambda", (Object[])new Object[0]), false);
                    JavaReplaceChoice chain = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.NO, JavaRefactoringBundle.message((String)"replace.as.separate.operation", (Object[])new Object[]{this.myChainMethodName}), true);
                    occurrencesMap.put(noChain, Collections.singletonList(expr2));
                    occurrencesMap.put(chain, Collections.singletonList(expr2));
                }
            } else {
                occurrencesMap.put(JavaReplaceChoice.NO, Collections.singletonList(expr2));
                if (this.myHasWriteAccess && !this.myCantReplaceAllButWrite) {
                    occurrencesMap.put(JavaReplaceChoice.NO_WRITE, this.myNonWrite);
                }
                if (this.myOccurrences.size() > 1 && !this.myCantReplaceAll) {
                    if (occurrencesMap.containsKey(JavaReplaceChoice.NO_WRITE)) {
                        JavaReplaceChoice choice = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.ALL, JavaRefactoringBundle.message((String)"replace.all.read.and.write", (Object[])new Object[0]), false);
                        occurrencesMap.put(choice, this.myOccurrences);
                    } else {
                        this.generateScopeBasedChoices(expr2, occurrencesMap);
                        occurrencesMap.put(JavaReplaceChoice.ALL, this.myOccurrences);
                    }
                }
            }
            return occurrencesMap;
        }

        private void generateScopeBasedChoices(PsiExpression expr2, LinkedHashMap<JavaReplaceChoice, List<PsiExpression>> occurrencesMap) {
            Comparator treeOrder = (e1, e2) -> {
                if (PsiTreeUtil.isAncestor((PsiElement)e1, (PsiElement)e2, (boolean)true)) {
                    return 1;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)e2, (PsiElement)e1, (boolean)true)) {
                    return -1;
                }
                return 0;
            };
            PsiElement physical = IntroduceVariableBase.getPhysicalElement((PsiElement)expr2);
            TreeMap groupByBlock = (TreeMap)StreamEx.of(this.myOccurrences).groupingBy(e -> PsiTreeUtil.findCommonParent((PsiElement)e, (PsiElement)physical), () -> new TreeMap(treeOrder), Collectors.toList());
            LOG.assertTrue(!groupByBlock.isEmpty());
            ArrayList currentOccurrences = new ArrayList();
            HashMap counts = new HashMap();
            groupByBlock.forEach((parent, occurrences) -> {
                int sameKeywordCount;
                PsiElement nextParent = groupByBlock.higherKey(parent);
                if (nextParent == null) {
                    return;
                }
                currentOccurrences.addAll(occurrences);
                if (currentOccurrences.size() == 1) {
                    return;
                }
                String keyword = null;
                for (PsiElement current = parent.getParent(); current != nextParent; current = current.getParent()) {
                    if (current instanceof PsiIfStatement || current instanceof PsiWhileStatement || current instanceof PsiForStatement || current instanceof PsiTryStatement) {
                        keyword = current.getFirstChild().getText();
                    } else if (current instanceof PsiDoWhileStatement) {
                        keyword = "do-while";
                    } else if (current instanceof PsiForeachStatement) {
                        keyword = "for-each";
                    } else if (current instanceof PsiLambdaExpression) {
                        keyword = "lambda";
                    }
                    if (keyword != null) break;
                }
                if (keyword == null && nextParent instanceof PsiIfStatement) {
                    PsiStatement thenBranch = ((PsiIfStatement)nextParent).getThenBranch();
                    PsiStatement elseBranch = ((PsiIfStatement)nextParent).getElseBranch();
                    if (PsiTreeUtil.isAncestor((PsiElement)thenBranch, (PsiElement)parent, (boolean)false)) {
                        keyword = "if-then";
                    } else if (PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)parent, (boolean)false)) {
                        keyword = "else";
                    }
                }
                if (keyword != null && (sameKeywordCount = counts.merge(keyword, 1, Integer::sum).intValue()) <= 2) {
                    JavaReplaceChoice choice = JavaReplaceChoice.allOccurrencesInside(parent, sameKeywordCount, keyword);
                    occurrencesMap.put(choice, new ArrayList(currentOccurrences));
                }
            });
        }
    }

    public static interface Validator {
        public boolean isOK(IntroduceVariableSettings var1);
    }

    public static class JavaReplaceChoice
    implements OccurrencesChooser.BaseReplaceChoice {
        public static final JavaReplaceChoice NO = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.NO, null, false);
        public static final JavaReplaceChoice NO_WRITE = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.NO_WRITE, null, false);
        public static final JavaReplaceChoice ALL = new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.ALL, null, false);
        private final String myDescription;
        private final boolean myChain;
        private final OccurrencesChooser.ReplaceChoice myChoice;

        JavaReplaceChoice(@NotNull OccurrencesChooser.ReplaceChoice choice, @Nullable @Nls String description, boolean chain) {
            this.myChoice = choice;
            this.myDescription = description;
            this.myChain = chain;
        }

        public boolean isAll() {
            return this.myChoice.isAll();
        }

        public boolean isChain() {
            return this.myChain;
        }

        public PsiExpression[] filter(ExpressionOccurrenceManager manager) {
            switch (this.myChoice) {
                case NO: {
                    return new PsiExpression[]{manager.getMainOccurence()};
                }
                case NO_WRITE: {
                    return (PsiExpression[])((StreamEx)StreamEx.of((Object[])manager.getOccurrences()).filter(expr2 -> !PsiUtil.isAccessedForWriting((PsiExpression)expr2))).toArray((Object[])PsiExpression.EMPTY_ARRAY);
                }
                case ALL: {
                    return manager.getOccurrences();
                }
            }
            throw new IllegalStateException("Unexpected value: " + this.myChoice);
        }

        public String formatDescription(int occurrencesCount) {
            return this.myDescription == null ? this.myChoice.formatDescription(occurrencesCount) : this.myDescription;
        }

        public String toString() {
            return this.formatDescription(0);
        }

        @NotNull
        private static JavaReplaceChoice allOccurrencesInside(final PsiElement parent, final int sameKeywordCount, final String finalKeyword) {
            return new JavaReplaceChoice(OccurrencesChooser.ReplaceChoice.ALL, null, false){

                @Override
                public PsiExpression[] filter(ExpressionOccurrenceManager manager) {
                    return (PsiExpression[])((StreamEx)StreamEx.of((Object[])manager.getOccurrences()).filter(expr2 -> PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)expr2, (boolean)true))).toArray((Object[])PsiExpression.EMPTY_ARRAY);
                }

                @Override
                public String formatDescription(int occurrencesCount) {
                    return JavaRefactoringBundle.message((String)"replace.occurrences.inside.statement", (Object[])new Object[]{occurrencesCount, finalKeyword, sameKeywordCount});
                }
            };
        }
    }
}

