/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class RetargetStaticMethodCall
extends FixableUsageInfo {
    private final String delegateClassName;
    private final PsiMethodCallExpression call;

    public RetargetStaticMethodCall(PsiMethodCallExpression call, String delegateClassName) {
        super((PsiElement)call);
        this.call = call;
        this.delegateClassName = delegateClassName;
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiReferenceExpression methodExpression = this.call.getMethodExpression();
        PsiExpression qualifier = (PsiExpression)methodExpression.getQualifier();
        if (qualifier == null) {
            PsiElement resolveScope = this.call.resolveMethodGenerics().getCurrentFileResolveScope();
            if (!(resolveScope instanceof PsiImportStaticStatement)) {
                MutationUtils.replaceExpression(this.delegateClassName + '.' + this.call.getText(), (PsiExpression)this.call);
            }
        } else {
            MutationUtils.replaceExpression(this.delegateClassName, qualifier);
        }
    }
}

