/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.MemberQualifierUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThisReferenceDescriptor
implements ItemToReplaceDescriptor {
    private final PsiThisExpression myThisExpression;
    private final PsiClass myPsiClass;

    public ThisReferenceDescriptor(PsiThisExpression expression2, PsiClass referredClass) {
        this.myThisExpression = expression2;
        this.myPsiClass = referredClass;
    }

    @Nullable
    public static ItemToReplaceDescriptor createIfInaccessible(@NotNull PsiThisExpression thisExpression) {
        PsiClass psiClass;
        PsiType expressionType = thisExpression.getType();
        if (expressionType != null && (psiClass = PsiTypesUtil.getPsiClass((PsiType)expressionType)) != null) {
            return new ThisReferenceDescriptor(thisExpression, psiClass);
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        String newExpression = MemberQualifierUtil.handleThisReference((PsiElement)this.myThisExpression, this.myPsiClass, outerClass, callExpression, elementFactory);
        this.myThisExpression.replace((PsiElement)elementFactory.createExpressionFromText(newExpression, (PsiElement)this.myThisExpression));
    }
}

