/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethodObject.reflect.FieldAccessType;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionAccessMethodBuilder {
    private static final Logger LOG = Logger.getInstance(ReflectionAccessMethodBuilder.class);
    private boolean myIsStatic = false;
    private String myReturnType = "void";
    private final String myName;
    private MyMemberAccessor myMemberAccessor;
    private final List<ParameterInfo> myParameters = new SmartList();

    public ReflectionAccessMethodBuilder(@NotNull String name2) {
        this.myName = name2;
    }

    public PsiMethod build(@NotNull PsiElementFactory elementFactory, @Nullable PsiElement context) {
        this.checkRequirements();
        String parameters2 = StreamEx.of(this.myParameters).map(p -> p.accessibleType + " " + p.name).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        String returnExpression2 = ("void".equals(this.myReturnType) ? "member." : "return (" + this.myReturnType + ")member.") + this.myMemberAccessor.getAccessExpression();
        String methodBody2 = "  java.lang.Class<?> klass = " + this.myMemberAccessor.getClassLookupExpression() + ";\n  " + this.myMemberAccessor.getMemberType() + " member = null;\n  int interfaceNumber = -1;\n  Class<?>[] interfaces = null;\n  while (member == null) {\n    try {\n      member = klass." + this.myMemberAccessor.getMemberLookupExpression() + ";\n    } catch (java.lang.ReflectiveOperationException e) {\n      if (interfaceNumber == -1) {\n        interfaces = klass.getInterfaces();\n        interfaceNumber = 0;\n      }\n      if (interfaceNumber < interfaces.length) {\n        klass = interfaces[interfaceNumber];\n        interfaceNumber += 1;\n      } else {\n        klass = klass.getSuperclass();\n        if (klass == null) throw e;\n        interfaceNumber = -1;\n      }\n    }\n  }\n  member.setAccessible(true);\n  " + returnExpression2 + ";\n";
        List<String> possibleExceptions = this.myMemberAccessor.getPossibleExceptions();
        if (!possibleExceptions.isEmpty()) {
            methodBody2 = "try {\n" + methodBody2 + "}" + ReflectionAccessMethodBuilder.createCatchBlocks(possibleExceptions);
        }
        String methodText = "public" + (this.myIsStatic ? " static " : " ") + this.myReturnType + " " + this.myName + parameters2 + " { \n" + methodBody2 + "}\n";
        return elementFactory.createMethodFromText(methodText, context);
    }

    private void checkRequirements() {
        if (this.myMemberAccessor == null) {
            LOG.error("Accessed member not specified");
        }
    }

    public ReflectionAccessMethodBuilder accessedMethod(@NotNull String jvmClassName, @NotNull String methodName) {
        this.myMemberAccessor = new MyMethodAccessor(jvmClassName, methodName);
        return this;
    }

    public ReflectionAccessMethodBuilder accessedField(@NotNull String jvmClassName, @NotNull String fieldName) {
        this.myMemberAccessor = new MyFieldAccessor(jvmClassName, fieldName, FieldAccessType.GET);
        return this;
    }

    public ReflectionAccessMethodBuilder updatedField(@NotNull String jvmClassName, @NotNull String fieldName) {
        this.myMemberAccessor = new MyFieldAccessor(jvmClassName, fieldName, FieldAccessType.SET);
        return this;
    }

    public ReflectionAccessMethodBuilder accessedConstructor(@NotNull String jvmClassName) {
        this.myMemberAccessor = new MyConstructorAccessor(jvmClassName);
        return this;
    }

    public ReflectionAccessMethodBuilder setReturnType(@NotNull String returnType) {
        this.myReturnType = returnType;
        return this;
    }

    public ReflectionAccessMethodBuilder setStatic(boolean isStatic) {
        this.myIsStatic = isStatic;
        return this;
    }

    public ReflectionAccessMethodBuilder addParameter(@NotNull String jvmType, @NotNull String name2) {
        this.myParameters.add(new ParameterInfo(jvmType.replace('$', '.'), name2, jvmType));
        return this;
    }

    public ReflectionAccessMethodBuilder addParameters(@NotNull PsiParameterList parameterList) {
        PsiParameter[] parameters2 = parameterList.getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            PsiType parameterType = parameter2.getType();
            PsiType erasedType = TypeConversionUtil.erasure((PsiType)parameterType);
            String typeName = ReflectionAccessMethodBuilder.typeName(parameterType, erasedType);
            String jvmType = erasedType != null ? ReflectionAccessMethodBuilder.extractJvmType(erasedType) : typeName;
            String name2 = parameter2.getName();
            PsiType accessedType = erasedType != null ? PsiReflectionAccessUtil.nearestAccessibleType(erasedType) : PsiReflectionAccessUtil.nearestAccessibleType(parameterType);
            this.myParameters.add(new ParameterInfo(accessedType.getCanonicalText(), name2, jvmType));
        }
        return this;
    }

    @NotNull
    private static String typeName(@NotNull PsiType type2, @Nullable PsiType erasedType) {
        if (erasedType == null) {
            String typeName = type2.getCanonicalText();
            int typeParameterIndex = typeName.indexOf(60);
            if (typeParameterIndex != -1) {
                typeName = typeName.substring(0, typeParameterIndex);
            }
            LOG.warn("Type erasure failed, the following type used instead: " + typeName);
            return typeName;
        }
        return erasedType.getCanonicalText();
    }

    @NotNull
    private static String extractJvmType(@NotNull PsiType type2) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        String canonicalText = type2.getCanonicalText();
        String jvmName = psiClass == null ? canonicalText : ClassUtil.getJVMClassName((PsiClass)psiClass);
        return jvmName == null ? canonicalText : jvmName;
    }

    private static String createCatchBlocks(@NotNull List<String> exceptions) {
        return StreamEx.of(exceptions).map(x -> "catch(" + x + " e) { throw new java.lang.RuntimeException(e); }").joining((CharSequence)"\n");
    }

    private class MyConstructorAccessor
    implements MyMemberAccessor {
        private final String myClassName;

        MyConstructorAccessor(String className2) {
            this.myClassName = className2;
        }

        @Override
        public String getMemberLookupExpression() {
            String args = StreamEx.of((Collection)ReflectionAccessMethodBuilder.this.myParameters).map(x -> x.jvmTypeName).map(PsiReflectionAccessUtil::classForName).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
            return "getDeclaredConstructor" + args;
        }

        @Override
        public String getClassLookupExpression() {
            return PsiReflectionAccessUtil.classForName(this.myClassName);
        }

        @Override
        public String getAccessExpression() {
            String args = StreamEx.of((Collection)ReflectionAccessMethodBuilder.this.myParameters).map(x -> x.name).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
            return "newInstance" + args;
        }

        @Override
        public String getMemberType() {
            return "java.lang.reflect.Constructor<?>";
        }

        @Override
        public List<String> getPossibleExceptions() {
            return Collections.unmodifiableList(Collections.singletonList("java.lang.ReflectiveOperationException"));
        }
    }

    private class MyMethodAccessor
    implements MyMemberAccessor {
        private final String myClassName;
        private final String myMethodName;

        MyMethodAccessor(@NotNull String className2, String methodName) {
            this.myClassName = className2;
            this.myMethodName = methodName;
        }

        @Override
        public String getMemberLookupExpression() {
            String args = ((StreamEx)StreamEx.of((Collection)ReflectionAccessMethodBuilder.this.myParameters).skip(1L)).map(x -> PsiReflectionAccessUtil.classForName(x.jvmTypeName)).prepend((Object)StringUtil.wrapWithDoubleQuote((String)this.myMethodName)).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
            return "getDeclaredMethod" + args;
        }

        @Override
        public String getClassLookupExpression() {
            return PsiReflectionAccessUtil.classForName(this.myClassName);
        }

        @Override
        public String getMemberType() {
            return "java.lang.reflect.Method";
        }

        @Override
        public List<String> getPossibleExceptions() {
            return Collections.unmodifiableList(Collections.singletonList("java.lang.ReflectiveOperationException"));
        }

        @Override
        public String getAccessExpression() {
            return StreamEx.of((Collection)ReflectionAccessMethodBuilder.this.myParameters).map(x -> x.name).joining((CharSequence)", ", (CharSequence)"invoke(", (CharSequence)")");
        }
    }

    private static class MyFieldAccessor
    implements MyMemberAccessor {
        private static final List<String> EXCEPTIONS = Collections.unmodifiableList(Collections.singletonList("java.lang.ReflectiveOperationException"));
        private final String myFieldName;
        private final String myClassName;
        private final FieldAccessType myAccessType;

        MyFieldAccessor(@NotNull String className2, @NotNull String fieldName, @NotNull FieldAccessType accessType) {
            this.myFieldName = fieldName;
            this.myClassName = className2;
            this.myAccessType = accessType;
        }

        @Override
        public String getClassLookupExpression() {
            return PsiReflectionAccessUtil.classForName(this.myClassName);
        }

        @Override
        public String getMemberLookupExpression() {
            return "getDeclaredField(" + StringUtil.wrapWithDoubleQuote((String)this.myFieldName) + ")";
        }

        @Override
        public String getAccessExpression() {
            return FieldAccessType.GET.equals((Object)this.myAccessType) ? "get(object)" : "set(object, value)";
        }

        @Override
        public String getMemberType() {
            return "java.lang.reflect.Field";
        }

        @Override
        public List<String> getPossibleExceptions() {
            return EXCEPTIONS;
        }
    }

    private static interface MyMemberAccessor {
        public String getMemberLookupExpression();

        public String getClassLookupExpression();

        public String getAccessExpression();

        public String getMemberType();

        public List<String> getPossibleExceptions();
    }

    private static class ParameterInfo {
        public final String accessibleType;
        public final String name;
        public final String jvmTypeName;

        ParameterInfo(@NotNull String accessibleType, @NotNull String name2, @NotNull String jvmTypeName) {
            this.accessibleType = accessibleType;
            this.name = name2;
            this.jvmTypeName = jvmTypeName;
        }
    }
}

