/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.FieldAccessType;
import com.intellij.refactoring.extractMethodObject.reflect.MemberQualifierUtil;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessMethodBuilder;
import java.lang.reflect.Array;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldDescriptor
implements ItemToReplaceDescriptor {
    private static final Logger LOG = Logger.getInstance(FieldDescriptor.class);
    private final PsiField myField;
    private final PsiReferenceExpression myExpression;
    private final String myAccessibleType;

    private FieldDescriptor(@NotNull PsiField field, @NotNull PsiReferenceExpression expression2) {
        this.myField = field;
        this.myExpression = expression2;
        String fieldType = PsiReflectionAccessUtil.getAccessibleReturnType((PsiExpression)this.myExpression, FieldDescriptor.resolveFieldType(this.myField, this.myExpression));
        if (fieldType == null) {
            LOG.warn("Could not resolve field type. java.lang.Object will be used instead");
            fieldType = "java.lang.Object";
        }
        this.myAccessibleType = fieldType;
    }

    @Nullable
    public static ItemToReplaceDescriptor createIfInaccessible(@NotNull PsiClass outerClass, @NotNull PsiReferenceExpression expression2) {
        PsiField field;
        PsiClass containingClass;
        PsiElement resolved = expression2.resolve();
        if (resolved instanceof PsiField && !Objects.equals(containingClass = (field = (PsiField)resolved).getContainingClass(), outerClass) && FieldDescriptor.needReplace(outerClass, field, expression2)) {
            Array.getLength(new int[3]);
            return new FieldDescriptor(field, expression2);
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        PsiElement parent = this.myExpression.getParent();
        if (parent instanceof PsiAssignmentExpression && Objects.equals(this.myExpression, ((PsiAssignmentExpression)parent).getLExpression())) {
            this.grantUpdateAccess((PsiAssignmentExpression)parent, outerClass, callExpression, elementFactory);
        } else {
            this.grantReadAccess(outerClass, callExpression, elementFactory);
        }
    }

    private void grantReadAccess(@NotNull PsiClass outerClass, @NotNull PsiMethodCallExpression generatedCall, @NotNull PsiElementFactory elementFactory) {
        PsiMethod newMethod = this.createPsiMethod(FieldAccessType.GET, outerClass, elementFactory);
        if (newMethod == null) {
            return;
        }
        outerClass.add((PsiElement)newMethod);
        String object = MemberQualifierUtil.findObjectExpression(this.myExpression, (PsiMember)this.myField, outerClass, generatedCall, elementFactory);
        String methodCall = newMethod.getName() + "(" + (object == null ? "null" : object) + ", null)";
        this.myExpression.replace((PsiElement)elementFactory.createExpressionFromText(methodCall, (PsiElement)this.myExpression));
    }

    private void grantUpdateAccess(@NotNull PsiAssignmentExpression assignmentExpression, @NotNull PsiClass outerClass, @NotNull PsiMethodCallExpression generatedCall, @NotNull PsiElementFactory elementFactory) {
        PsiMethod newMethod = this.createPsiMethod(FieldAccessType.SET, outerClass, elementFactory);
        if (newMethod == null) {
            return;
        }
        outerClass.add((PsiElement)newMethod);
        PsiExpression rightExpression = assignmentExpression.getRExpression();
        if (rightExpression == null) {
            LOG.warn("Expression representing a new field value not found");
            return;
        }
        String newValue = rightExpression.getText();
        String objectForReference = MemberQualifierUtil.findObjectExpression(this.myExpression, (PsiMember)this.myField, outerClass, generatedCall, elementFactory);
        String args = (objectForReference == null ? "null" : objectForReference) + ", " + newValue;
        String methodCallExpression = newMethod.getName() + "(" + args + ")";
        PsiExpression newMethodCallExpression = elementFactory.createExpressionFromText(methodCallExpression, (PsiElement)this.myExpression);
        assignmentExpression.replace((PsiElement)newMethodCallExpression);
    }

    @Nullable
    private PsiMethod createPsiMethod(FieldAccessType accessType, PsiClass outerClass, PsiElementFactory elementFactory) {
        PsiClass containingClass = this.myField.getContainingClass();
        String className2 = containingClass == null ? null : ClassUtil.getJVMClassName((PsiClass)containingClass);
        String fieldName = this.myField.getName();
        if (className2 == null) {
            LOG.warn("Code is incomplete. Class name or field name not found");
            return null;
        }
        String methodName = PsiReflectionAccessUtil.getUniqueMethodName(outerClass, "accessToField" + StringUtil.capitalize((String)fieldName));
        ReflectionAccessMethodBuilder methodBuilder = new ReflectionAccessMethodBuilder(methodName);
        if (FieldAccessType.GET.equals((Object)accessType)) {
            methodBuilder.accessedField(className2, fieldName).setReturnType(this.myAccessibleType);
        } else {
            methodBuilder.updatedField(className2, fieldName).setReturnType("void");
        }
        methodBuilder.setStatic(outerClass.hasModifierProperty("static")).addParameter("java.lang.Object", "object").addParameter("java.lang.Object", "value");
        return methodBuilder.build(elementFactory, (PsiElement)outerClass);
    }

    private static boolean needReplace(@NotNull PsiClass outerClass, @NotNull PsiField field, @NotNull PsiReferenceExpression expression2) {
        return !PsiReflectionAccessUtil.isAccessibleMember((PsiMember)field, outerClass, expression2.getQualifierExpression());
    }

    @NotNull
    private static PsiType resolveFieldType(@NotNull PsiField field, @NotNull PsiReferenceExpression referenceExpression) {
        PsiType rawType = field.getType();
        return referenceExpression.advancedResolve(false).getSubstitutor().substitute(rawType);
    }
}

