/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.ReusedLocalVariable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReusedLocalVariablesFinder {
    private final ControlFlow myControlFlow;
    private final PsiStatement myNextStatement;
    private final int myOffset;
    private final JavaCodeStyleManager myCodeStyleManager;

    private ReusedLocalVariablesFinder(@NotNull ControlFlow controlFlow, @NotNull PsiStatement nextStatement, int offset) {
        this.myControlFlow = controlFlow;
        this.myNextStatement = nextStatement;
        this.myOffset = offset;
        this.myCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myNextStatement.getProject());
    }

    static List<ReusedLocalVariable> findReusedLocalVariables(@NotNull PsiElement fragmentStart, @NotNull PsiElement fragmentEnd, @NotNull Set<PsiLocalVariable> ignoreVariables, @NotNull InputVariables inputVariables) {
        List<PsiLocalVariable> declaredVariables = ReusedLocalVariablesFinder.getDeclaredVariables(fragmentStart, fragmentEnd, ignoreVariables);
        if (declaredVariables.isEmpty()) {
            return Collections.emptyList();
        }
        ReusedLocalVariablesFinder finder = ReusedLocalVariablesFinder.createFinder(fragmentEnd);
        if (finder == null) {
            return Collections.emptyList();
        }
        List reusedVariables = ContainerUtil.filter(declaredVariables, finder::isVariableReused);
        if (reusedVariables.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ReusedLocalVariable> result = new ArrayList<ReusedLocalVariable>();
        HashSet<String> tempNames = new HashSet<String>(ContainerUtil.map(inputVariables.getInputVariables(), data -> data.name));
        for (PsiLocalVariable variable : reusedVariables) {
            String name2 = variable.getName();
            String typeText = variable.getType().getCanonicalText();
            if (finder.isValueReused((PsiVariable)variable)) {
                String suggestedName = finder.suggestUniqueVariableName(name2);
                String tempName = UniqueNameGenerator.generateUniqueName((String)suggestedName, tempNames);
                tempNames.add(tempName);
                result.add(new ReusedLocalVariable(name2, tempName, typeText, true));
                continue;
            }
            result.add(new ReusedLocalVariable(name2, null, typeText, false));
        }
        return result;
    }

    private static List<PsiLocalVariable> getDeclaredVariables(@NotNull PsiElement start, @NotNull PsiElement end, @NotNull Set<PsiLocalVariable> ignoreVariables) {
        SmartList result = new SmartList();
        PsiElement element = start;
        while (element != null) {
            if (element instanceof PsiDeclarationStatement) {
                PsiElement[] declaredElements;
                for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)element).getDeclaredElements()) {
                    if (!(declaredElement instanceof PsiLocalVariable) || ignoreVariables.contains(declaredElement)) continue;
                    result.add((PsiLocalVariable)declaredElement);
                }
            }
            element = element != end ? element.getNextSibling() : null;
        }
        return result;
    }

    @Nullable
    private static ReusedLocalVariablesFinder createFinder(@NotNull PsiElement fragmentEnd) {
        ControlFlow controlFlow;
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)fragmentEnd, PsiStatement.class);
        if (nextStatement == null) {
            return null;
        }
        PsiElement codeFragment = ControlFlowUtil.findCodeFragment((PsiElement)nextStatement);
        try {
            controlFlow = ControlFlowFactory.getInstance(codeFragment.getProject()).getControlFlow(codeFragment, new LocalsControlFlowPolicy(codeFragment), false, false);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        int offset = controlFlow.getStartOffset((PsiElement)nextStatement);
        if (offset < 0) {
            return null;
        }
        return new ReusedLocalVariablesFinder(controlFlow, nextStatement, offset);
    }

    private boolean isVariableReused(@NotNull PsiVariable variable) {
        return ControlFlowUtil.isVariableUsed(this.myControlFlow, this.myOffset, this.myControlFlow.getSize(), variable);
    }

    private boolean isValueReused(@NotNull PsiVariable variable) {
        return ControlFlowUtil.needVariableValueAt(variable, this.myControlFlow, this.myOffset);
    }

    private String suggestUniqueVariableName(String name2) {
        return this.myCodeStyleManager.suggestUniqueVariableName(name2, (PsiElement)this.myNextStatement, true);
    }
}

