/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ParametersFolder {
    private final Map<PsiVariable, PsiExpression> myExpressions = new HashMap<PsiVariable, PsiExpression>();
    private final Map<PsiVariable, String> myArgs = new HashMap<PsiVariable, String>();
    private final Map<PsiVariable, List<PsiExpression>> myMentionedInExpressions = new HashMap<PsiVariable, List<PsiExpression>>();
    private final Set<PsiVariable> myDeleted = new HashSet<PsiVariable>();
    private boolean myFoldingSelectedByDefault;

    ParametersFolder() {
    }

    void clear() {
        this.myExpressions.clear();
        this.myMentionedInExpressions.clear();
        this.myDeleted.clear();
    }

    boolean isParameterSafeToDelete(@NotNull VariableData data, @NotNull LocalSearchScope scope) {
        block0: for (PsiReference reference : ReferencesSearch.search((PsiElement)data.variable, (SearchScope)scope)) {
            PsiElement expression2 = reference.getElement();
            while (expression2 != null) {
                for (PsiExpression psiExpression : this.myExpressions.values()) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expression2, (PsiElement)psiExpression)) continue;
                    continue block0;
                }
                expression2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpression.class);
            }
            return false;
        }
        PsiExpression psiExpression = this.myExpressions.get(data.variable);
        if (psiExpression == null) {
            return true;
        }
        for (PsiVariable variable : this.myExpressions.keySet()) {
            PsiExpression expr2;
            if (variable == data.variable || this.myDeleted.contains(variable) || (expr2 = this.myExpressions.get(variable)) == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expr2, (PsiElement)psiExpression)) continue;
            this.myDeleted.add(data.variable);
            return true;
        }
        return false;
    }

    void foldParameterUsagesInBody(@NotNull List<? extends VariableData> datum, PsiElement @NotNull [] elements, @NotNull SearchScope scope) {
        LinkedHashMap equivalentExpressions = new LinkedHashMap();
        for (VariableData variableData : datum) {
            PsiExpression psiExpression;
            if (this.myDeleted.contains(variableData.variable) || (psiExpression = this.myExpressions.get(variableData.variable)) == null) continue;
            HashSet<PsiExpression> eqExpressions = new HashSet<PsiExpression>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)variableData.variable, (SearchScope)scope)) {
                PsiExpression expression2 = ParametersFolder.findEquivalent(psiExpression, reference.getElement());
                if (expression2 == null || !expression2.isValid()) continue;
                eqExpressions.add(expression2);
            }
            equivalentExpressions.put(variableData, eqExpressions);
        }
        for (VariableData variableData : equivalentExpressions.keySet()) {
            Set eqExpressions = (Set)equivalentExpressions.get((Object)variableData);
            block3: for (PsiExpression expression3 : eqExpressions) {
                if (!expression3.isValid()) continue;
                PsiExpression refExpression = JavaPsiFacade.getElementFactory((Project)expression3.getProject()).createExpressionFromText(variableData.name, (PsiElement)expression3);
                PsiElement replaced = expression3.replace((PsiElement)refExpression);
                for (PsiElement psiElement : elements) {
                    if (expression3 != psiElement) continue;
                    elements[i] = replaced;
                    continue block3;
                }
            }
        }
    }

    boolean isParameterFoldable(@NotNull VariableData data, @NotNull LocalSearchScope scope, @NotNull List<? extends PsiVariable> inputVariables, @NotNull UniqueNameGenerator nameGenerator, @NotNull String defaultName) {
        List<PsiExpression> mentionedInExpressions = this.getMentionedExpressions(data.variable, scope, inputVariables);
        if (mentionedInExpressions == null) {
            return false;
        }
        int currentRank = 0;
        PsiExpression mostRanked = null;
        for (int i = mentionedInExpressions.size() - 1; i >= 0; --i) {
            PsiExpression expression2 = mentionedInExpressions.get(i);
            int r = ParametersFolder.findUsedVariables(data, inputVariables, expression2).size();
            if (currentRank >= r && (!(expression2 instanceof PsiArrayAccessExpression) || !this.myFoldingSelectedByDefault || currentRank != r)) continue;
            currentRank = r;
            mostRanked = expression2;
        }
        if (mostRanked != null) {
            this.myExpressions.put(data.variable, mostRanked);
            this.myArgs.put(data.variable, mostRanked.getText());
            data.type = RefactoringChangeUtil.getTypeByExpression(mostRanked);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)mostRanked.getProject());
            SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, mostRanked, data.type);
            if (nameInfo.names.length > 0 && !Objects.equals(nameInfo.names[0], data.name) && !Objects.equals(nameInfo.names[0], defaultName)) {
                data.name = nameInfo.names[0];
                ParametersFolder.setUniqueName(data, nameGenerator, mostRanked, codeStyleManager);
            }
        }
        return mostRanked != null;
    }

    private static void setUniqueName(@NotNull VariableData data, @NotNull UniqueNameGenerator nameGenerator, @NotNull PsiExpression expr2, @NotNull JavaCodeStyleManager codeStyleManager) {
        String name2 = data.name;
        int idx = 1;
        while (true) {
            if (nameGenerator.isUnique(name2, "", "") && name2.equals(codeStyleManager.suggestUniqueVariableName(name2, (PsiElement)expr2, true))) break;
            name2 = data.name + idx++;
        }
        data.name = name2;
        nameGenerator.addExistingName(name2);
    }

    @NotNull
    private static Set<PsiVariable> findUsedVariables(@NotNull VariableData data, final @NotNull List<? extends PsiVariable> inputVariables, @NotNull PsiExpression expression2) {
        final HashSet<PsiVariable> found = new HashSet<PsiVariable>();
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiVariable && inputVariables.contains(resolved)) {
                    found.add((PsiVariable)resolved);
                }
            }
        });
        found.remove(data.variable);
        return found;
    }

    boolean isFoldable() {
        return !this.myExpressions.isEmpty();
    }

    @Nullable
    private List<PsiExpression> getMentionedExpressions(@NotNull PsiVariable var, @NotNull LocalSearchScope scope, @NotNull List<? extends PsiVariable> inputVariables) {
        if (this.myMentionedInExpressions.containsKey(var)) {
            return this.myMentionedInExpressions.get(var);
        }
        PsiElement[] scopeElements = scope.getScope();
        ArrayList<PsiExpression> expressions2 = null;
        Boolean arrayAccess = null;
        block0: for (PsiReference reference : ReferencesSearch.search((PsiElement)var, (SearchScope)scope)) {
            PsiElement expression2 = reference.getElement();
            if (expressions2 == null) {
                expressions2 = new ArrayList<PsiExpression>();
                while (expression2 instanceof PsiExpression) {
                    PsiType expressionType;
                    PsiElement parent;
                    if (ParametersFolder.isAccessedForWriting((PsiExpression)expression2)) {
                        return null;
                    }
                    if (ParametersFolder.isAncestor(expression2, scopeElements) || ParametersFolder.dependsOnLocals(expression2, inputVariables) || (parent = expression2.getParent()) instanceof PsiExpressionStatement || (expressionType = ((PsiExpression)expression2).getType()) == null || PsiType.VOID.equals((Object)expressionType) || ParametersFolder.isTooLongExpressionChain(expression2)) continue block0;
                    if (!ParametersFolder.isMethodNameExpression(expression2)) {
                        expressions2.add((PsiExpression)expression2);
                    }
                    if (expression2 instanceof PsiArrayAccessExpression && (arrayAccess == null || arrayAccess.booleanValue())) {
                        arrayAccess = ParametersFolder.isSafeToFoldArrayAccess(scope, expression2);
                    }
                    expression2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpression.class);
                }
                continue;
            }
            Iterator iterator = expressions2.iterator();
            while (iterator.hasNext()) {
                PsiExpression equivalent = ParametersFolder.findEquivalent((PsiExpression)iterator.next(), expression2);
                if (equivalent == null) {
                    iterator.remove();
                    continue;
                }
                if (!(equivalent instanceof PsiArrayAccessExpression) || arrayAccess != null && !arrayAccess.booleanValue()) continue;
                arrayAccess = ParametersFolder.isSafeToFoldArrayAccess(scope, (PsiElement)equivalent);
            }
        }
        if (arrayAccess != null && arrayAccess.booleanValue()) {
            this.myFoldingSelectedByDefault = true;
        }
        this.myMentionedInExpressions.put(var, expressions2);
        return expressions2;
    }

    private static boolean isSafeToFoldArrayAccess(@NotNull LocalSearchScope scope, PsiElement expression2) {
        while (true) {
            PsiElement parent;
            if ((parent = expression2.getParent()) != null && scope.containsRange(parent.getContainingFile(), parent.getTextRange())) {
                if (parent instanceof PsiIfStatement || parent instanceof PsiConditionalExpression || parent instanceof PsiSwitchStatement) {
                    return false;
                }
            } else {
                return true;
            }
            expression2 = parent;
        }
    }

    private static boolean isAccessedForWriting(@NotNull PsiExpression expression2) {
        final PsiExpression[] exprWithWriteAccessInside = new PsiExpression[1];
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (exprWithWriteAccessInside[0] != null) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitExpression(PsiExpression expression2) {
                if (PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
                    exprWithWriteAccessInside[0] = expression2;
                }
                super.visitExpression(expression2);
            }
        });
        return exprWithWriteAccessInside[0] != null;
    }

    private static boolean isAncestor(@NotNull PsiElement expression2, PsiElement @NotNull [] scopeElements) {
        for (PsiElement scopeElement : scopeElements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)expression2, (PsiElement)scopeElement, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTooLongExpressionChain(@NotNull PsiElement expression2) {
        int count = 0;
        PsiElement element = ParametersFolder.getInnerExpression(expression2);
        while (element != null) {
            if (++count > 1) {
                return true;
            }
            element = ParametersFolder.getInnerExpression(element);
        }
        return false;
    }

    private static PsiElement getInnerExpression(@NotNull PsiElement expression2) {
        if (expression2 instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression();
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            while (expression2 instanceof PsiArrayAccessExpression) {
                expression2 = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            }
            return expression2;
        }
        return null;
    }

    private static boolean isMethodNameExpression(@NotNull PsiElement expression2) {
        PsiElement parent = expression2.getParent();
        return expression2 instanceof PsiReferenceExpression && parent instanceof PsiMethodCallExpression && ((PsiReferenceExpression)expression2).getReferenceNameElement() == ((PsiMethodCallExpression)parent).getMethodExpression().getReferenceNameElement();
    }

    private static boolean dependsOnLocals(@NotNull PsiElement expression2, final @NotNull List<? extends PsiVariable> inputVariables) {
        final boolean[] localVarsUsed = new boolean[]{false};
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiVariable variable;
                PsiElement resolved = expression2.resolve();
                if (resolved instanceof PsiVariable && !((variable = (PsiVariable)resolved) instanceof PsiField) && !inputVariables.contains(variable)) {
                    localVarsUsed[0] = true;
                    return;
                }
                super.visitReferenceExpression(expression2);
            }
        });
        return localVarsUsed[0];
    }

    @NotNull
    String getGeneratedCallArgument(@NotNull VariableData data) {
        return this.myArgs.containsKey(data.variable) ? this.myArgs.get(data.variable) : data.variable.getName();
    }

    void putCallArgument(@NotNull PsiVariable argument, @NotNull PsiExpression value2) {
        this.myArgs.put(argument, value2.getText());
    }

    boolean annotateWithParameter(@NotNull VariableData data, @NotNull PsiElement element) {
        PsiExpression expression2;
        PsiExpression psiExpression = this.myExpressions.get(data.variable);
        if (psiExpression != null && (expression2 = ParametersFolder.findEquivalent(psiExpression, element)) != null) {
            expression2.putUserData(DuplicatesFinder.PARAMETER, (Object)new DuplicatesFinder.Parameter(data.variable, expression2.getType(), true));
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiExpression findEquivalent(PsiExpression expr2, @NotNull PsiElement element) {
        PsiElement expression2 = element;
        while (expression2 != null) {
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expression2, (PsiElement)expr2)) {
                PsiExpression psiExpression = (PsiExpression)expression2;
                return PsiUtil.isAccessedForWriting((PsiExpression)psiExpression) ? null : psiExpression;
            }
            expression2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpression.class);
        }
        return null;
    }

    boolean wasExcluded(@NotNull PsiVariable variable) {
        return this.myDeleted.contains(variable) || this.myMentionedInExpressions.containsKey(variable) && this.myExpressions.get(variable) == null;
    }

    boolean isFoldingSelectedByDefault() {
        return this.myFoldingSelectedByDefault;
    }
}

