/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.ExtractMethodSnapshot;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethod.newImpl.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.newImpl.MethodExtractor;
import com.intellij.refactoring.extractMethod.preview.ExtractMethodPreviewManager;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(ExtractMethodHandler.class);

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (dataContext != null) {
            PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (file != null && editor != null) {
                ExtractMethodHandler.invokeOnElements(project, editor, file, elements);
            }
        }
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        Pass<PsiElement[]> callback = new Pass<PsiElement[]>(){

            public void pass(PsiElement[] selectedValue) {
                ExtractMethodHandler.invokeOnElements(project, editor, file, selectedValue);
            }
        };
        ExtractMethodHandler.selectAndPass(project, editor, file, callback);
    }

    public static void selectAndPass(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, final @NotNull Pass<PsiElement[]> callback) {
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (!editor.getSelectionModel().hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            List<PsiExpression> expressions2 = IntroduceVariableBase.collectExpressions(file, editor, offset, true);
            if (expressions2.isEmpty()) {
                editor.getSelectionModel().selectLineAtCaret();
            } else {
                if (expressions2.size() == 1) {
                    callback.pass((Object)new PsiElement[]{(PsiElement)expressions2.get(0)});
                    return;
                }
                IntroduceTargetChooser.showChooser((Editor)editor, expressions2, (Pass)new Pass<PsiExpression>(){

                    public void pass(PsiExpression psiExpression) {
                        callback.pass((Object)new PsiElement[]{psiExpression});
                    }
                }, (Function)new PsiExpressionTrimRenderer.RenderFunction());
                return;
            }
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        callback.pass((Object)ExtractMethodHandler.getElements(project, editor, file));
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        PsiElement[] elements = ExtractMethodHandler.getElements(file.getProject(), editor, file);
        return elements != null && elements.length > 0;
    }

    public static PsiElement[] getElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement[] elements;
            int endOffset;
            int startOffset = selectionModel.getSelectionStart();
            PsiExpression expr2 = CodeInsightUtil.findExpressionInRange(file, startOffset, endOffset = selectionModel.getSelectionEnd());
            if (expr2 != null) {
                elements = new PsiElement[]{expr2};
            } else {
                PsiType originalType;
                PsiExpression expression2;
                elements = CodeInsightUtil.findStatementsInRange(file, startOffset, endOffset);
                if (elements.length == 0 && (expression2 = IntroduceVariableBase.getSelectedExpression(project, file, startOffset, endOffset)) != null && IntroduceVariableBase.getErrorMessage(expression2) == null && (originalType = RefactoringUtil.getTypeByExpressionWithExpectedType(expression2)) != null) {
                    elements = new PsiElement[]{expression2};
                }
            }
            return elements;
        }
        List<PsiExpression> expressions2 = IntroduceVariableBase.collectExpressions(file, editor, editor.getCaretModel().getOffset());
        return expressions2.toArray(PsiElement.EMPTY_ARRAY);
    }

    public static boolean canUseNewImpl(@NotNull Project project, PsiFile file, PsiElement @NotNull [] elements) {
        ExtractMethodProcessor processor2 = ExtractMethodHandler.getProcessor(project, elements, file, false);
        if (processor2 == null) {
            return true;
        }
        try {
            processor2.prepare(null);
            processor2.prepareVariablesAndName();
            processor2.myMethodName = "extracted";
        }
        catch (PrepareFailedException e) {
            return true;
        }
        return processor2.estimateDuplicatesCount() == 0 && !processor2.myInputVariables.isFoldable();
    }

    public static void invokeOnElements(final @NotNull Project project, final Editor editor, PsiFile file, PsiElement @NotNull [] elements) {
        if (Registry.is((String)"java.refactoring.extractMethod.newImplementation") && ExtractMethodHandler.canUseNewImpl(project, file, elements)) {
            TextRange selection = ExtractMethodHelper.findEditorSelection(editor);
            if (selection == null && elements.length == 1) {
                selection = elements[0].getTextRange();
            }
            if (selection != null) {
                new MethodExtractor().doExtract(file, selection, ExtractMethodHandler.getRefactoringName(), "refactoring.extractMethod");
            }
            return;
        }
        ExtractMethodHandler.getProcessor(elements, project, file, editor, true, new Pass<ExtractMethodProcessor>(){

            public void pass(ExtractMethodProcessor processor2) {
                ExtractMethodHandler.invokeOnElements(project, editor, processor2, true);
            }
        });
    }

    private static boolean invokeOnElements(@NotNull Project project, @NotNull Editor editor, @NotNull ExtractMethodProcessor processor2, boolean directTypes) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)processor2.getTargetClass().getContainingFile())) {
            return false;
        }
        processor2.setPreviewSupported(true);
        if (processor2.showDialog(directTypes)) {
            if (processor2.isPreviewDuplicates()) {
                ExtractMethodHandler.previewExtractMethod(processor2);
                return true;
            }
            ExtractMethodHandler.extractMethod(project, processor2);
            DuplicatesImpl.processDuplicates(processor2, project, editor);
            return true;
        }
        return false;
    }

    private static void previewExtractMethod(@NotNull ExtractMethodProcessor processor2) {
        processor2.previewRefactoring(null);
        ExtractMethodPreviewManager.getInstance(processor2.getProject()).showPreview(processor2);
    }

    public static void extractMethod(@NotNull Project project, @NotNull ExtractMethodProcessor processor2) {
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> ExtractMethodHandler.doRefactoring(project, processor2)), ExtractMethodHandler.getRefactoringName(), null);
    }

    private static void doRefactoring(@NotNull Project project, @NotNull ExtractMethodProcessor processor2) {
        try {
            RefactoringEventData beforeData = new RefactoringEventData();
            beforeData.addElements(processor2.myElements);
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted("refactoring.extract.method", beforeData);
            processor2.doRefactoring();
            RefactoringEventData data = new RefactoringEventData();
            data.addElement((PsiElement)processor2.getExtractedMethod());
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone("refactoring.extract.method", data);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static ExtractMethodProcessor getProcessor(PsiElement[] elements, Project project, PsiFile file, Editor editor, boolean showErrorMessages, @Nullable Pass<ExtractMethodProcessor> pass) {
        if (elements == null || elements.length == 0) {
            if (showErrorMessages) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)ExtractMethodHandler.getRefactoringName(), (String)"refactoring.extractMethod");
            }
            return null;
        }
        for (PsiElement element : elements) {
            if (element instanceof PsiStatement && JavaHighlightUtil.isSuperOrThisCall((PsiStatement)element, true, true)) {
                if (showErrorMessages) {
                    String message3 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.block.contains.invocation.of.another.class.constructor", (Object[])new Object[0]));
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)ExtractMethodHandler.getRefactoringName(), (String)"refactoring.extractMethod");
                }
                return null;
            }
            if (!(element instanceof PsiStatement) || PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) != null) continue;
            if (showErrorMessages) {
                String message4 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.block.contains.statement.outside.of.class", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message4, (String)ExtractMethodHandler.getRefactoringName(), (String)"refactoring.extractMethod");
            }
            return null;
        }
        String initialMethodName = Optional.ofNullable(ExtractMethodSnapshot.SNAPSHOT_KEY.get((UserDataHolder)file)).map(s -> s.myMethodName).orElse("");
        ExtractMethodProcessor processor2 = new ExtractMethodProcessor(project, editor, elements, null, ExtractMethodHandler.getRefactoringName(), initialMethodName, "refactoring.extractMethod");
        processor2.setShowErrorDialogs(showErrorMessages);
        try {
            if (!processor2.prepare(pass)) {
                return null;
            }
        }
        catch (PrepareFailedException e) {
            if (showErrorMessages) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)ExtractMethodHandler.getRefactoringName(), (String)"refactoring.extractMethod");
                ExtractMethodHandler.highlightPrepareError(e, file, editor, project);
            }
            return null;
        }
        return processor2;
    }

    public static void highlightPrepareError(PrepareFailedException e, PsiFile file, Editor editor, Project project) {
        if (e.getFile() == file) {
            TextRange textRange = e.getTextRange();
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
            editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
        }
    }

    @Nullable
    public static ExtractMethodProcessor getProcessor(Project project, PsiElement[] elements, PsiFile file, boolean openEditor) {
        return ExtractMethodHandler.getProcessor(elements, project, file, openEditor ? ExtractMethodHandler.openEditor(file) : null, false, null);
    }

    public static boolean invokeOnElements(Project project, @NotNull ExtractMethodProcessor processor2, PsiFile file, boolean directTypes) {
        return ExtractMethodHandler.invokeOnElements(project, ExtractMethodHandler.openEditor(file), processor2, directTypes);
    }

    @Nullable
    public static Editor openEditor(@NotNull PsiFile file) {
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, virtualFile);
        return FileEditorManager.getInstance((Project)project).openTextEditor(fileDescriptor, false);
    }

    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"extract.method.title");
    }
}

