/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseJavaRefactoringAction;
import com.intellij.refactoring.actions.RefactoringActionContextUtil;
import com.intellij.refactoring.replaceConstructorWithBuilder.ReplaceConstructorWithBuilderHandler;
import org.jetbrains.annotations.NotNull;

public class ReplaceConstructorWithBuilderAction
extends BaseJavaRefactoringAction {
    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context, @NotNull String place) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAt = file.findElementAt(offset);
        PsiClass psiClass = ReplaceConstructorWithBuilderHandler.getParentNamedClass(elementAt);
        if (psiClass == null || psiClass.getConstructors().length == 0 || psiClass.isEnum()) {
            return false;
        }
        if (ActionPlaces.isPopupPlace((String)place) || place.equals("RefactoringQuickList")) {
            PsiMethod method = RefactoringActionContextUtil.getJavaMethodHeader(elementAt);
            return method != null && method.isConstructor();
        }
        return true;
    }

    protected boolean isEnabledOnElements(PsiElement @NotNull [] elements) {
        return false;
    }

    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        return new ReplaceConstructorWithBuilderHandler();
    }
}

