/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiPatternUtil {
    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariables(@NotNull PsiExpression expression2) {
        boolean parentMayAccept;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        boolean bl = parentMayAccept = parent instanceof PsiPrefixExpression && ((PsiPrefixExpression)parent).getOperationTokenType().equals(JavaTokenType.EXCL) || parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.ANDAND) || parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.OROR) || parent instanceof PsiConditionalExpression || parent instanceof PsiIfStatement || parent instanceof PsiConditionalLoopStatement;
        if (!parentMayAccept) {
            return Collections.emptyList();
        }
        ArrayList<PsiPatternVariable> list = new ArrayList<PsiPatternVariable>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression2, expression2, list, false);
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariablesIgnoreParent(@NotNull PsiExpression expression2) {
        ArrayList<PsiPatternVariable> list = new ArrayList<PsiPatternVariable>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression2, expression2, list, true);
        return list;
    }

    @Nullable
    public static String getEffectiveInitializerText(@NotNull PsiPatternVariable variable) {
        PsiPattern pattern = variable.getPattern();
        PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)ObjectUtils.tryCast((Object)pattern.getParent(), PsiInstanceOfExpression.class);
        if (instanceOf == null) {
            return null;
        }
        if (pattern instanceof PsiTypeTestPattern) {
            PsiExpression operand2 = instanceOf.getOperand();
            PsiTypeElement checkType = ((PsiTypeTestPattern)pattern).getCheckType();
            if (checkType.getType().equals(operand2.getType())) {
                return operand2.getText();
            }
            return "(" + checkType.getText() + ")" + operand2.getText();
        }
        return null;
    }

    private static void collectPatternVariableCandidates(@NotNull PsiExpression scope, @NotNull PsiExpression expression2, Collection<PsiPatternVariable> candidates, boolean strict) {
        PsiPolyadicExpression polyadicExpression;
        IElementType tokenType;
        PsiPatternVariable variable;
        PsiPattern pattern;
        while (true) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
                continue;
            }
            if (!(expression2 instanceof PsiPrefixExpression) || !((PsiPrefixExpression)expression2).getOperationTokenType().equals(JavaTokenType.EXCL)) break;
            expression2 = ((PsiPrefixExpression)expression2).getOperand();
        }
        if (expression2 instanceof PsiInstanceOfExpression && (pattern = ((PsiInstanceOfExpression)expression2).getPattern()) instanceof PsiTypeTestPattern && (variable = ((PsiTypeTestPattern)pattern).getPatternVariable()) != null && !PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)variable.getDeclarationScope(), (boolean)strict)) {
            candidates.add(variable);
        }
        if (expression2 instanceof PsiPolyadicExpression && ((tokenType = (polyadicExpression = (PsiPolyadicExpression)expression2).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR))) {
            for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                JavaPsiPatternUtil.collectPatternVariableCandidates(scope, operand2, candidates, strict);
            }
        }
    }
}

