/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordHeaderElement
extends CompositeElement
implements Constants {
    private final TokenSet RECORD_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.RECORD_COMPONENT});

    public RecordHeaderElement() {
        super(RECORD_HEADER);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child.getElementType() == JavaElementType.RECORD_COMPONENT) {
            JavaSourceUtil.deleteSeparatingComma(this, child);
        }
        super.deleteChildInternal(child);
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, @Nullable ASTNode anchor, @Nullable Boolean before) {
        if (anchor == null) {
            if (before == null || before.booleanValue()) {
                anchor = this.findChildByType(JavaTokenType.RPARENTH);
                before = Boolean.TRUE;
            } else {
                anchor = this.findChildByType(JavaTokenType.LPARENTH);
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor, before);
        if (first == last && first.getElementType() == JavaElementType.RECORD_COMPONENT) {
            JavaSourceUtil.addSeparatingComma(this, (ASTNode)first, this.RECORD_TOKEN_SET);
        }
        return firstAdded;
    }
}

