/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSuperExpressionImpl
extends ExpressionPsiElement
implements PsiSuperExpression,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiSuperExpressionImpl.class);

    public PsiSuperExpressionImpl() {
        super(SUPER_EXPRESSION);
    }

    public PsiJavaCodeReferenceElement getQualifier() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    public PsiType getType() {
        PsiJavaCodeReferenceElement qualifier = this.getQualifier();
        if (qualifier != null) {
            PsiElement aClass = qualifier.resolve();
            if (!(aClass instanceof PsiClass)) {
                return null;
            }
            return this.getSuperType((PsiClass)aClass, PsiUtil.isLanguageLevel8OrHigher((PsiElement)this));
        }
        for (PsiElement scope = this.getContext(); scope != null; scope = scope.getContext()) {
            PsiType fragmentSuperType;
            if (scope instanceof PsiClass) {
                PsiClass aClass = (PsiClass)scope;
                return this.getSuperType(aClass, false);
            }
            if (scope instanceof PsiExpressionList && scope.getParent() instanceof PsiAnonymousClass) {
                scope = scope.getParent();
                continue;
            }
            if (!(scope instanceof JavaCodeFragment) || (fragmentSuperType = ((JavaCodeFragment)scope).getSuperType()) == null) continue;
            return fragmentSuperType;
        }
        return null;
    }

    @Nullable
    private PsiType getSuperType(PsiClass aClass, boolean checkImmediateSuperInterfaces) {
        PsiClassType[] superTypes;
        PsiClass containingClass;
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return null;
        }
        PsiClass psiClass = containingClass = checkImmediateSuperInterfaces ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiClass.class) : null;
        if (containingClass != null) {
            superTypes = containingClass.isInterface() ? containingClass.getExtendsListTypes() : (containingClass instanceof PsiAnonymousClass ? new PsiClassType[]{((PsiAnonymousClass)containingClass).getBaseClassType()} : containingClass.getImplementsListTypes());
            for (PsiClassType superType : superTypes) {
                PsiClass superClass = superType.resolve();
                if (superClass == null || !superClass.isInterface() || !aClass.equals(superClass)) continue;
                return superType;
            }
        }
        if (aClass.isInterface()) {
            return PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
            PsiClass psiClass2 = baseClassType.resolve();
            return psiClass2 != null && !psiClass2.isInterface() ? baseClassType : PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
        }
        superTypes = aClass.getExtendsListTypes();
        return superTypes.length == 0 ? PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope()) : superTypes[0];
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 54: {
                return this.getFirstChildNode().getElementType() == JAVA_CODE_REFERENCE ? this.getFirstChildNode() : null;
            }
            case 55: {
                return this.findChildByType(DOT);
            }
            case 96: 
        }
        return this.getLastChildNode();
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == DOT) {
            return 55;
        }
        if (i == SUPER_KEYWORD) {
            return 96;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitSuperExpression((PsiSuperExpression)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiSuperExpression:" + this.getText();
    }
}

