/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PatternResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPolyadicExpressionImpl
extends ExpressionPsiElement
implements PsiPolyadicExpression {
    private static final Logger LOG = Logger.getInstance(PsiPolyadicExpressionImpl.class);
    private static final Function<PsiPolyadicExpressionImpl, PsiType> MY_TYPE_EVALUATOR = expression2 -> PsiPolyadicExpressionImpl.doGetType(expression2);
    private static final TokenSet OUR_OPERATIONS_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.OROR, JavaTokenType.ANDAND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.AND, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC});
    private volatile PsiExpression[] cachedOperands;

    public PsiPolyadicExpressionImpl() {
        super(JavaElementType.POLYADIC_EXPRESSION);
    }

    @NotNull
    public IElementType getOperationTokenType() {
        return ((PsiJavaToken)this.findChildByRoleAsPsiElement(63)).getTokenType();
    }

    public PsiJavaToken getTokenBeforeOperand(@NotNull PsiExpression operand2) {
        for (PsiExpression element = operand2; element != null; element = element.getPrevSibling()) {
            if (this.getChildRole(element.getNode()) != 63) continue;
            return (PsiJavaToken)element;
        }
        return null;
    }

    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, MY_TYPE_EVALUATOR);
    }

    @Nullable
    private static PsiType doGetType(PsiPolyadicExpressionImpl param) {
        PsiExpression[] operands2 = param.getOperands();
        PsiType lType = null;
        IElementType sign = param.getOperationTokenType();
        for (int i = 1; i < operands2.length; ++i) {
            PsiType rType = operands2[i].getType();
            PsiType type2 = TypeConversionUtil.calcTypeForBinaryExpression(null, (PsiType)rType, (IElementType)sign, (boolean)false);
            if (type2 != TypeConversionUtil.NULL_TYPE) {
                return type2;
            }
            if (lType == null) {
                lType = operands2[0].getType();
            }
            lType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)sign, (boolean)true);
        }
        return lType;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        if (role == 63) {
            return this.findChildByType(OUR_OPERATIONS_BIT_SET);
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (OUR_OPERATIONS_BIT_SET.contains(child.getElementType())) {
            return 63;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitPolyadicExpression((PsiPolyadicExpression)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public PsiExpression @NotNull [] getOperands() {
        PsiExpression[] operands2 = this.cachedOperands;
        if (operands2 == null) {
            this.cachedOperands = operands2 = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.EXPRESSION_BIT_SET, PsiExpression.ARRAY_FACTORY);
        }
        return operands2;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return PsiPolyadicExpressionImpl.processDeclarations(this, processor2, state, lastParent, place);
    }

    static boolean processDeclarations(@NotNull PsiPolyadicExpression expression2, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        IElementType tokenType = expression2.getOperationTokenType();
        boolean and = tokenType.equals(JavaTokenType.ANDAND);
        boolean or = tokenType.equals(JavaTokenType.OROR);
        if (!and && !or) {
            return true;
        }
        ElementClassHint elementClassHint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (elementClassHint != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        PatternResolveState wantedHint = PatternResolveState.fromBoolean(and);
        if (state.get(PatternResolveState.KEY) == wantedHint.invert()) {
            return true;
        }
        return PsiScopesUtil.walkChildrenScopes((PsiElement)expression2, processor2, wantedHint.putInto(state), lastParent, place);
    }

    public void clearCaches() {
        this.cachedOperands = null;
        super.clearCaches();
    }

    public String toString() {
        return "PsiPolyadicExpression: " + this.getText();
    }
}

