/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCatchSectionImpl
extends CompositePsiElement
implements PsiCatchSection,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiCatchSectionImpl.class);
    private final Object myTypesCacheLock = new Object();
    private CachedValue<List<PsiType>> myTypesCache;

    public PsiCatchSectionImpl() {
        super(CATCH_SECTION);
    }

    public PsiParameter getParameter() {
        return (PsiParameter)this.findChildByRoleAsPsiElement(15);
    }

    public PsiCodeBlock getCatchBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(49);
    }

    public PsiType getCatchType() {
        PsiParameter parameter2 = this.getParameter();
        if (parameter2 == null) {
            return null;
        }
        return parameter2.getType();
    }

    @NotNull
    public List<PsiType> getPreciseCatchTypes() {
        PsiParameter parameter2 = this.getParameter();
        if (parameter2 == null) {
            return Collections.emptyList();
        }
        return (List)this.getTypesCache().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        super.clearCaches();
        Object object = this.myTypesCacheLock;
        synchronized (object) {
            this.myTypesCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedValue<List<PsiType>> getTypesCache() {
        Object object = this.myTypesCacheLock;
        synchronized (object) {
            if (this.myTypesCache == null) {
                CachedValuesManager cacheManager = CachedValuesManager.getManager((Project)this.getProject());
                this.myTypesCache = cacheManager.createCachedValue(() -> {
                    List<PsiType> types = this.computePreciseCatchTypes(this.getParameter());
                    return CachedValueProvider.Result.create(types, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }, false);
            }
            return this.myTypesCache;
        }
    }

    private List<PsiType> computePreciseCatchTypes(@Nullable PsiParameter parameter2) {
        if (parameter2 == null) {
            return ContainerUtil.emptyList();
        }
        PsiType declaredType = parameter2.getType();
        if (PsiUtil.getLanguageLevel((PsiElement)parameter2).isAtLeast(LanguageLevel.JDK_1_7) && PsiCatchSectionImpl.isCatchParameterEffectivelyFinal(parameter2, this.getCatchBlock())) {
            PsiTryStatement statement = this.getTryStatement();
            Collection<PsiClassType> thrownTypes = PsiCatchSectionImpl.getThrownTypes(statement);
            if (thrownTypes.isEmpty()) {
                return Collections.emptyList();
            }
            Object[] parameters2 = statement.getCatchBlockParameters();
            int currentIdx = ArrayUtil.find((Object[])parameters2, (Object)parameter2);
            List uncaughtTypes = ContainerUtil.mapNotNull(thrownTypes, (Function)((NullableFunction)arg_0 -> PsiCatchSectionImpl.lambda$computePreciseCatchTypes$1(currentIdx, (PsiParameter[])parameters2, arg_0)));
            if (uncaughtTypes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<PsiType> types = new ArrayList<PsiType>();
            for (PsiType type2 : uncaughtTypes) {
                if (!declaredType.isAssignableFrom(type2) && (!ExceptionUtil.isGeneralExceptionType(declaredType) || !(type2 instanceof PsiClassType) || !ExceptionUtil.isUncheckedException((PsiClassType)type2))) continue;
                types.add(type2);
            }
            if (!types.isEmpty()) {
                return types;
            }
        }
        return Collections.singletonList(declaredType);
    }

    private static Collection<PsiClassType> getThrownTypes(@NotNull PsiTryStatement statement) {
        PsiResourceList resourceList;
        ArrayList<PsiClassType> types = new ArrayList<PsiClassType>();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        if (tryBlock != null) {
            types.addAll(ExceptionUtil.getThrownExceptions((PsiElement)tryBlock));
        }
        if ((resourceList = statement.getResourceList()) != null) {
            types.addAll(ExceptionUtil.getThrownExceptions((PsiElement)resourceList));
        }
        return types;
    }

    private static boolean isCatchParameterEffectivelyFinal(final PsiParameter parameter2, @Nullable PsiCodeBlock catchBlock) {
        final boolean[] result = new boolean[]{true};
        if (catchBlock != null) {
            catchBlock.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    super.visitReferenceExpression(expression2);
                    if (expression2.resolve() == parameter2 && PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
                        result[0] = false;
                        this.stopWalking();
                    }
                }
            });
        }
        return result[0];
    }

    @NotNull
    public PsiTryStatement getTryStatement() {
        return (PsiTryStatement)this.getParent();
    }

    @Nullable
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRole(50);
    }

    @Nullable
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRole(51);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitCatchSection((PsiCatchSection)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiCatchSection";
    }

    public ASTNode findChildByRole(int role) {
        switch (role) {
            default: {
                return null;
            }
            case 15: {
                return this.findChildByType(PARAMETER);
            }
            case 46: {
                return this.findChildByType(CATCH_KEYWORD);
            }
            case 50: {
                return this.findChildByType(LPARENTH);
            }
            case 51: {
                return this.findChildByType(RPARENTH);
            }
            case 49: 
        }
        return this.findChildByType((IElementType)CODE_BLOCK);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == PARAMETER) {
            return 15;
        }
        if (i == CODE_BLOCK) {
            return 49;
        }
        if (i == CATCH_KEYWORD) {
            return 46;
        }
        if (i == LPARENTH) {
            return 50;
        }
        if (i == RPARENTH) {
            return 51;
        }
        return 0;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null || lastParent.getParent() != this) {
            return true;
        }
        PsiParameter catchParameter = this.getParameter();
        if (catchParameter != null) {
            return processor2.execute((PsiElement)catchParameter, state);
        }
        return PsiScopesUtil.walkChildrenScopes((PsiElement)this, processor2, state, lastParent, place);
    }

    private static /* synthetic */ PsiType lambda$computePreciseCatchTypes$1(int currentIdx, PsiParameter[] parameters2, PsiClassType thrownType) {
        for (int i = 0; i < currentIdx; ++i) {
            PsiType catchType = parameters2[i].getType();
            if (!catchType.isAssignableFrom((PsiType)thrownType)) continue;
            return null;
        }
        return thrownType;
    }
}

