/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class PsiAssignmentExpressionImpl
extends ExpressionPsiElement
implements PsiAssignmentExpression {
    private static final Logger LOG = Logger.getInstance(PsiAssignmentExpressionImpl.class);
    private static final TokenSet OUR_OPERATIONS_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.PERCEQ, JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.LTLTEQ, JavaTokenType.GTGTEQ, JavaTokenType.GTGTGTEQ, JavaTokenType.ANDEQ, JavaTokenType.OREQ, JavaTokenType.XOREQ});

    public PsiAssignmentExpressionImpl() {
        super(JavaElementType.ASSIGNMENT_EXPRESSION);
    }

    @NotNull
    public PsiExpression getLExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(61);
    }

    public PsiExpression getRExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(62);
    }

    @NotNull
    public PsiJavaToken getOperationSign() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(63);
    }

    @NotNull
    public IElementType getOperationTokenType() {
        return this.getOperationSign().getTokenType();
    }

    public PsiType getType() {
        PsiExpression lExpression = PsiUtil.deparenthesizeExpression((PsiExpression)this.getLExpression());
        if (lExpression instanceof PsiReferenceExpression || lExpression instanceof PsiArrayAccessExpression) {
            return lExpression.getType();
        }
        return null;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 61: {
                return this.getFirstChildNode();
            }
            case 62: {
                return ElementType.EXPRESSION_BIT_SET.contains(this.getLastChildNode().getElementType()) ? this.getLastChildNode() : null;
            }
            case 63: 
        }
        return this.findChildByType(OUR_OPERATIONS_BIT_SET);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            if (child == this.getFirstChildNode()) {
                return 61;
            }
            if (child == this.getLastChildNode()) {
                return 62;
            }
            return 0;
        }
        if (OUR_OPERATIONS_BIT_SET.contains(child.getElementType())) {
            return 63;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAssignmentExpression((PsiAssignmentExpression)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiAssignmentExpression:" + this.getText();
    }
}

