/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PatternUtil;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternPackageReferenceSet
extends PackageReferenceSet {
    public PatternPackageReferenceSet(@NotNull String packageName, @NotNull PsiElement element, int startInElement, @NotNull GlobalSearchScope scope) {
        super(packageName, element, startInElement, scope);
    }

    @Override
    public Collection<PsiPackage> resolvePackageName(@Nullable PsiPackage context, String packageName) {
        if (context == null) {
            return Collections.emptySet();
        }
        if (packageName.contains("*")) {
            LinkedHashSet<PsiPackage> packages = new LinkedHashSet<PsiPackage>();
            Pattern pattern = PatternUtil.fromMask((String)packageName);
            this.processSubPackages(context, (Processor<? super PsiPackage>)((Processor)psiPackage -> {
                String name2 = psiPackage.getName();
                if (name2 != null && pattern.matcher(name2).matches()) {
                    packages.add((PsiPackage)psiPackage);
                }
                return true;
            }));
            return packages;
        }
        return super.resolvePackageName(context, packageName);
    }

    protected boolean processSubPackages(PsiPackage pkg, Processor<? super PsiPackage> processor2) {
        for (PsiPackage aPackage : pkg.getSubPackages(this.getResolveScope())) {
            if (!processor2.process((Object)aPackage)) {
                return false;
            }
            if (this.processSubPackages(aPackage, processor2)) continue;
            return false;
        }
        return true;
    }
}

