/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodHandleCompletionContributor
extends CompletionContributor {
    private static final Set<String> METHOD_HANDLE_FACTORY_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"findConstructor", "findVirtual", "findStatic", "findSpecial"});
    private static final PsiJavaElementPattern.Capture<PsiElement> METHOD_TYPE_ARGUMENT_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{","})).withParent(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiExpression().methodCallParameter(1, (ElementPattern)JavaMethodHandleCompletionContributor.methodPattern("findConstructor")), PsiJavaPatterns.psiExpression().methodCallParameter(2, (ElementPattern)JavaMethodHandleCompletionContributor.methodPattern("findVirtual", "findStatic", "findSpecial"))}));
    private static final Set<String> FIELD_HANDLE_FACTORY_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"findGetter", "findSetter", "findStaticGetter", "findStaticSetter", "findVarHandle", "findStaticVarHandle"});
    private static final PsiJavaElementPattern.Capture<PsiElement> FIELD_TYPE_ARGUMENT_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{","})).withParent((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(2, (ElementPattern)JavaMethodHandleCompletionContributor.methodPattern(ArrayUtilRt.toStringArray(FIELD_HANDLE_FACTORY_NAMES))));

    @NotNull
    private static PsiMethodPattern methodPattern(String ... methodNames) {
        return ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(methodNames)).definedInClass("java.lang.invoke.MethodHandles.Lookup");
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result) {
        PsiElement position = parameters2.getPosition();
        if (!JavaCompletionContributor.isInJavaContext(position)) {
            return;
        }
        if (METHOD_TYPE_ARGUMENT_PATTERN.accepts((Object)position)) {
            JavaMethodHandleCompletionContributor.addMethodHandleVariants(position, (Consumer<? super LookupElement>)result);
        } else if (FIELD_TYPE_ARGUMENT_PATTERN.accepts((Object)position)) {
            JavaMethodHandleCompletionContributor.addFieldHandleVariants(position, (Consumer<? super LookupElement>)result);
        }
    }

    private static void addMethodHandleVariants(@NotNull PsiElement position, @NotNull Consumer<? super LookupElement> result) {
        String methodName;
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class);
        if (methodCall != null && (methodName = methodCall.getMethodExpression().getReferenceName()) != null && METHOD_HANDLE_FACTORY_NAMES.contains(methodName)) {
            JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            JavaReflectionReferenceUtil.ReflectiveClass reflectiveClass = ownerClass = arguments.length != 0 ? JavaReflectionReferenceUtil.getReflectiveClass(arguments[0]) : null;
            if (ownerClass != null) {
                switch (methodName) {
                    case "findConstructor": {
                        JavaMethodHandleCompletionContributor.addConstructorSignatures(ownerClass, position, result);
                        break;
                    }
                    case "findVirtual": 
                    case "findStatic": 
                    case "findSpecial": {
                        String name2;
                        String string = name2 = arguments.length > 1 ? JavaReflectionReferenceUtil.computeConstantExpression(arguments[1], String.class) : null;
                        if (StringUtil.isEmpty(name2)) break;
                        JavaMethodHandleCompletionContributor.addMethodSignatures(ownerClass, name2, "findStatic".equals(methodName), position, result);
                    }
                }
            }
        }
    }

    private static void addConstructorSignatures(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull PsiElement context, @NotNull Consumer<? super LookupElement> result) {
        PsiMethod[] constructors = ownerClass.getPsiClass().getConstructors();
        if (constructors.length != 0) {
            JavaMethodHandleCompletionContributor.lookupMethodTypes(Arrays.stream(constructors), context, result);
        } else {
            result.consume((Object)JavaMethodHandleCompletionContributor.lookupSignature(JavaReflectionReferenceUtil.ReflectiveSignature.NO_ARGUMENT_CONSTRUCTOR_SIGNATURE, context));
        }
    }

    private static void addMethodSignatures(@NotNull JavaReflectionReferenceUtil.ReflectiveClass psiClass, @NotNull String methodName, boolean isStaticExpected, @NotNull PsiElement context, @NotNull Consumer<? super LookupElement> result) {
        PsiMethod[] methods = psiClass.getPsiClass().findMethodsByName(methodName, false);
        if (methods.length != 0) {
            Stream<PsiMethod> methodStream = Arrays.stream(methods).filter(method -> method.hasModifierProperty("static") == isStaticExpected);
            JavaMethodHandleCompletionContributor.lookupMethodTypes(methodStream, context, result);
        }
    }

    private static void lookupMethodTypes(@NotNull Stream<? extends PsiMethod> methods, @NotNull PsiElement context, @NotNull Consumer<? super LookupElement> result) {
        methods.map(JavaReflectionReferenceUtil::getMethodSignature).filter(Objects::nonNull).sorted(JavaReflectionReferenceUtil.ReflectiveSignature::compareTo).map(signature -> JavaMethodHandleCompletionContributor.lookupSignature(signature, context)).forEach(arg_0 -> result.consume(arg_0));
    }

    @NotNull
    private static LookupElement lookupSignature(@NotNull JavaReflectionReferenceUtil.ReflectiveSignature signature, @NotNull PsiElement context) {
        String expressionText = JavaReflectionReferenceUtil.getMethodTypeExpressionText(signature);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        PsiExpression expression2 = factory.createExpressionFromText(expressionText, context);
        String shortTypes = signature.getText(true, type2 -> PsiNameHelper.getShortClassName((String)type2) + ".class");
        String presentableText = PsiNameHelper.getShortClassName((String)"java.lang.invoke.MethodType") + "." + "methodType" + shortTypes;
        String lookupText = "methodType" + signature.getText(true, PsiNameHelper::getShortClassName);
        return JavaMethodHandleCompletionContributor.lookupExpression(expression2, PlatformIcons.METHOD_ICON, presentableText, lookupText);
    }

    private static void addFieldHandleVariants(@NotNull PsiElement position, @NotNull Consumer<? super LookupElement> result) {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        String fieldName;
        PsiExpression[] arguments;
        String methodName;
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class);
        if (methodCall != null && (methodName = methodCall.getMethodExpression().getReferenceName()) != null && FIELD_HANDLE_FACTORY_NAMES.contains(methodName) && (arguments = methodCall.getArgumentList().getExpressions()).length > 2 && !StringUtil.isEmpty((String)(fieldName = JavaReflectionReferenceUtil.computeConstantExpression(arguments[1], String.class))) && (ownerClass = JavaReflectionReferenceUtil.getReflectiveClass(arguments[0])) != null) {
            JavaMethodHandleCompletionContributor.addFieldType(ownerClass, fieldName, position, result);
        }
    }

    private static void addFieldType(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, @NotNull String fieldName, @NotNull PsiElement context, @NotNull Consumer<? super LookupElement> result) {
        PsiField field = ownerClass.getPsiClass().findFieldByName(fieldName, false);
        if (field != null) {
            String typeText = JavaReflectionReferenceUtil.getTypeText(field.getType());
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)ownerClass.getPsiClass().getProject());
            PsiExpression expression2 = factory.createExpressionFromText(typeText + ".class", context);
            String shortType = PsiNameHelper.getShortClassName((String)typeText);
            result.consume((Object)JavaMethodHandleCompletionContributor.lookupExpression(expression2, PlatformIcons.CLASS_ICON, shortType + ".class", shortType));
        }
    }

    @NotNull
    private static LookupElement lookupExpression(@NotNull PsiExpression expression2, @Nullable Icon icon, @NotNull String presentableText, @NotNull String lookupText) {
        ExpressionLookupItem element = new ExpressionLookupItem(expression2, icon, presentableText, new String[]{lookupText}){

            @Override
            public void handleInsert(@NotNull InsertionContext context) {
                context.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
                context.commitDocument();
                JavaReflectionReferenceUtil.replaceText(context, this.getObject().getText());
            }
        };
        return PrioritizedLookupElement.withPriority((LookupElement)element, (double)1.0);
    }
}

