/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JavaIndentHelper
extends IndentHelperImpl {
    protected int getIndentInner(@NotNull PsiFile file, @NotNull ASTNode element, boolean includeNonSpace, int recursionLevel) {
        if (recursionLevel > 450) {
            return 0;
        }
        if (element.getTreePrev() != null) {
            ASTNode parent;
            ASTNode prev = element.getTreePrev();
            while (prev instanceof CompositeElement && !TreeUtil.isStrongWhitespaceHolder((IElementType)prev.getElementType())) {
                ASTNode lastCompositePrev = prev;
                if ((prev = prev.getLastChildNode()) != null) continue;
                return this.getIndentInner(file, lastCompositePrev, includeNonSpace, recursionLevel + 1);
            }
            String text2 = prev.getText();
            int index = Math.max(text2.lastIndexOf(10), text2.lastIndexOf(13));
            if (index >= 0) {
                return JavaIndentHelper.getIndent((PsiFile)file, (String)text2.substring(index + 1), (boolean)includeNonSpace);
            }
            if (includeNonSpace) {
                return this.getIndentInner(file, prev, includeNonSpace, recursionLevel + 1) + JavaIndentHelper.getIndent((PsiFile)file, (String)text2, (boolean)includeNonSpace);
            }
            if (element.getElementType() == JavaElementType.CODE_BLOCK) {
                parent = element.getTreeParent();
                if (parent.getElementType() == JavaElementType.BLOCK_STATEMENT) {
                    parent = parent.getTreeParent();
                }
                if (parent.getElementType() != JavaElementType.CODE_BLOCK) {
                    return this.getIndentInner(file, parent, includeNonSpace, recursionLevel + 1);
                }
            } else if (element.getElementType() == JavaTokenType.LBRACE) {
                return this.getIndentInner(file, element.getTreeParent(), includeNonSpace, recursionLevel + 1);
            }
            ASTNode child = prev;
            for (parent = prev.getTreeParent(); parent != null && child.getTreePrev() == null; parent = parent.getTreeParent()) {
                child = parent;
            }
            if (parent == null) {
                return JavaIndentHelper.getIndent((PsiFile)file, (String)text2, (boolean)includeNonSpace);
            }
            if (prev.getTreeParent().getElementType() == JavaElementType.LABELED_STATEMENT) {
                return this.getIndentInner(file, prev, true, recursionLevel + 1) + JavaIndentHelper.getIndent((PsiFile)file, (String)text2, (boolean)true);
            }
            return this.getIndentInner(file, prev, includeNonSpace, recursionLevel + 1);
        }
        if (element.getTreeParent() == null) {
            return 0;
        }
        return this.getIndentInner(file, element.getTreeParent(), includeNonSpace, recursionLevel + 1);
    }
}

