/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.annotations.NotNull;

public class PsiEnumConstantInitializerImpl
extends PsiClassImpl
implements PsiEnumConstantInitializer {
    private static final Logger LOG = Logger.getInstance(PsiEnumConstantInitializerImpl.class);
    private PsiClassType myCachedBaseType;

    public PsiEnumConstantInitializerImpl(PsiClassStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER);
    }

    public PsiEnumConstantInitializerImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiEnumConstantInitializerImpl clone = (PsiEnumConstantInitializerImpl)super.clone();
        clone.myCachedBaseType = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    public PsiExpressionList getArgumentList() {
        PsiElement parent = this.getParent();
        LOG.assertTrue(parent instanceof PsiEnumConstant);
        return ((PsiCall)parent).getArgumentList();
    }

    public boolean isInQualifiedNew() {
        return false;
    }

    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiClass containingClass = this.getBaseClass();
        return new LightClassReference((PsiManager)this.getManager(), containingClass.getName(), containingClass);
    }

    private PsiClass getBaseClass() {
        PsiElement parent = this.getParent();
        LOG.assertTrue(parent instanceof PsiEnumConstant, (Object)parent);
        PsiClass containingClass = ((PsiEnumConstant)parent).getContainingClass();
        LOG.assertTrue(containingClass != null);
        return containingClass;
    }

    @NotNull
    public PsiEnumConstant getEnumConstant() {
        return (PsiEnumConstant)this.getParent();
    }

    @NotNull
    public PsiClassType getBaseClassType() {
        PsiClassType cachedBaseType = this.myCachedBaseType;
        if (cachedBaseType == null) {
            this.myCachedBaseType = cachedBaseType = JavaPsiFacade.getElementFactory((Project)this.getProject()).createType(this.getBaseClass());
        }
        return cachedBaseType;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        return false;
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return null;
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return null;
    }

    @Override
    public PsiClassType @NotNull [] getSuperTypes() {
        return new PsiClassType[]{this.getBaseClassType()};
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitEnumConstantInitializer((PsiEnumConstantInitializer)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiAnonymousClass (PsiEnumConstantInitializerImpl)):";
    }
}

