/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightClassTypeReference;
import com.intellij.psi.impl.source.ClassReferencePointer;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassReferenceType
extends PsiClassType.Stub {
    private final ClassReferencePointer myReference;

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level) {
        this(reference, level, PsiClassReferenceType.collectAnnotations(reference));
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, PsiAnnotation @NotNull [] annotations) {
        super(level, annotations);
        this.myReference = ClassReferencePointer.constant(reference);
    }

    public PsiClassReferenceType(@NotNull PsiJavaCodeReferenceElement reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        this(ClassReferencePointer.constant(reference), level, provider);
    }

    PsiClassReferenceType(@NotNull ClassReferencePointer reference, LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        super(level, provider);
        this.myReference = reference;
    }

    private static PsiAnnotation @NotNull [] collectAnnotations(PsiJavaCodeReferenceElement reference) {
        List result = null;
        for (PsiElement child = reference.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiAnnotation)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add((PsiAnnotation)child);
        }
        return result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(PsiAnnotation.EMPTY_ARRAY);
    }

    public boolean isValid() {
        PsiJavaCodeReferenceElement reference = this.myReference.retrieveReference();
        if (reference != null && reference.isValid()) {
            for (PsiAnnotation annotation : this.getAnnotations(false)) {
                if (annotation.isValid()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalsToText(@NotNull String text2) {
        PsiJavaCodeReferenceElement reference = this.getReference();
        String name2 = reference.getReferenceName();
        return (name2 == null || text2.contains(name2)) && Objects.equals(text2, this.getCanonicalText());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.getReference().getResolveScope();
    }

    public PsiAnnotation @NotNull [] getAnnotations() {
        return this.getAnnotations(true);
    }

    private PsiAnnotation[] getAnnotations(boolean merge) {
        PsiJavaCodeReferenceElement reference;
        Object[] annotations = super.getAnnotations();
        if (merge && (reference = this.myReference.retrieveReference()) != null && reference.isValid() && reference.isQualified()) {
            Object[] embedded = PsiClassReferenceType.collectAnnotations(reference);
            if (annotations.length > 0 && embedded.length > 0) {
                LinkedHashSet set = new LinkedHashSet();
                ContainerUtil.addAll(set, (Object[])annotations);
                ContainerUtil.addAll(set, (Object[])embedded);
                annotations = set.toArray(PsiAnnotation.EMPTY_ARRAY);
            } else {
                annotations = (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])annotations, (Object[])embedded);
            }
        }
        return annotations;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        if (this.myLanguageLevel != null) {
            return this.myLanguageLevel;
        }
        return PsiUtil.getLanguageLevel((PsiElement)this.getReference());
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel.equals((Object)this.myLanguageLevel)) {
            return this;
        }
        return new PsiClassReferenceType(this.getReference(), languageLevel, this.getAnnotationProvider());
    }

    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        if (!reference.isValid()) {
            if (reference instanceof LightClassTypeReference) {
                PsiUtil.ensureValidType((PsiType)((LightClassTypeReference)reference).getType());
            }
            throw new PsiInvalidElementAccessException((PsiElement)reference, this.myReference.toString() + "; augmenters=" + PsiAugmentProvider.EP_NAME.getExtensionList());
        }
        JavaResolveResult result = reference.advancedResolve(false);
        return result.getElement() == null ? PsiClassType.ClassResolveResult.EMPTY : new DelegatingClassResolveResult(result);
    }

    @NotNull
    public PsiClassType rawType() {
        PsiJavaCodeReferenceElement reference = this.getReference();
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (!PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass).iterator().hasNext()) {
                return this;
            }
            PsiManager manager = reference.getManager();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
            PsiSubstitutor rawSubstitutor = factory.createRawSubstitutor((PsiTypeParameterListOwner)aClass);
            return new PsiImmediateClassType(aClass, rawSubstitutor, this.getLanguageLevel(), this.getAnnotationProvider());
        }
        String qualifiedName = reference.getQualifiedName();
        String name2 = reference.getReferenceName();
        if (name2 == null) {
            name2 = "";
        }
        LightClassReference lightReference = new LightClassReference(reference.getManager(), name2, qualifiedName, reference.getResolveScope());
        return new PsiClassReferenceType((PsiJavaCodeReferenceElement)lightReference, null, this.getAnnotationProvider());
    }

    public String getClassName() {
        return this.getReference().getReferenceName();
    }

    public PsiType @NotNull [] getParameters() {
        return this.getReference().getTypeParameters();
    }

    @NotNull
    public String getPresentableText(boolean annotated) {
        PsiJavaCodeReferenceElement ref = this.getReference();
        if (!annotated) {
            return PsiNameHelper.getPresentableText((PsiJavaCodeReferenceElement)ref);
        }
        PsiAnnotation[] annotations = ref.getQualifier() != null ? (PsiAnnotation[])ObjectUtils.notNull((Object)PsiTreeUtil.getChildrenOfType((PsiElement)ref, PsiAnnotation.class), (Object)PsiAnnotation.EMPTY_ARRAY) : this.getAnnotations(false);
        return PsiNameHelper.getPresentableText((String)ref.getReferenceName(), (PsiAnnotation[])annotations, (PsiType[])ref.getTypeParameters());
    }

    @NotNull
    public String getCanonicalText(boolean annotated) {
        return this.getText(annotated);
    }

    @NotNull
    public String getInternalCanonicalText() {
        return this.getCanonicalText(true);
    }

    private String getText(boolean annotated) {
        PsiJavaCodeReferenceElement reference = this.getReference();
        if (reference instanceof PsiAnnotatedJavaCodeReferenceElement) {
            PsiAnnotatedJavaCodeReferenceElement ref = (PsiAnnotatedJavaCodeReferenceElement)reference;
            PsiAnnotation[] annotations = annotated ? this.getAnnotations(false) : PsiAnnotation.EMPTY_ARRAY;
            return ref.getCanonicalText(annotated, annotations.length == 0 ? null : annotations);
        }
        return reference.getCanonicalText();
    }

    @NotNull
    public PsiJavaCodeReferenceElement getReference() {
        return this.myReference.retrieveNonNullReference();
    }

    @Nullable
    public PsiElement getPsiContext() {
        return this.myReference.retrieveReference();
    }

    private static class DelegatingClassResolveResult
    implements PsiClassType.ClassResolveResult {
        private final JavaResolveResult myDelegate;

        private DelegatingClassResolveResult(@NotNull JavaResolveResult delegate) {
            this.myDelegate = delegate;
        }

        @NotNull
        public PsiSubstitutor getSubstitutor() {
            return this.myDelegate.getSubstitutor();
        }

        public boolean isValidResult() {
            return this.myDelegate.isValidResult();
        }

        public boolean isAccessible() {
            return this.myDelegate.isAccessible();
        }

        public boolean isStaticsScopeCorrect() {
            return this.myDelegate.isStaticsScopeCorrect();
        }

        public PsiElement getCurrentFileResolveScope() {
            return this.myDelegate.getCurrentFileResolveScope();
        }

        public boolean isPackagePrefixPackageReference() {
            return this.myDelegate.isPackagePrefixPackageReference();
        }

        public PsiClass getElement() {
            PsiElement element = this.myDelegate.getElement();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }
    }
}

