/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightParameterListBuilder
extends LightElement
implements PsiParameterList {
    private final List<PsiParameter> myParameters = new ArrayList<PsiParameter>();
    private PsiParameter[] myCachedParameters;

    public LightParameterListBuilder(PsiManager manager, Language language) {
        super(manager, language);
    }

    public void addParameter(PsiParameter parameter2) {
        this.myParameters.add(parameter2);
        this.myCachedParameters = null;
    }

    public String toString() {
        return "Light parameter list";
    }

    public PsiParameter @NotNull [] getParameters() {
        if (this.myCachedParameters == null) {
            this.myCachedParameters = this.myParameters.isEmpty() ? PsiParameter.EMPTY_ARRAY : this.myParameters.toArray(PsiParameter.EMPTY_ARRAY);
        }
        return this.myCachedParameters;
    }

    @Nullable
    public PsiParameter getParameter(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index is negative: " + index);
        }
        if (index < this.myParameters.size()) {
            return this.myParameters.get(index);
        }
        return null;
    }

    public int getParameterIndex(@NotNull PsiParameter parameter2) {
        return this.myParameters.indexOf(parameter2);
    }

    public int getParametersCount() {
        return this.myParameters.size();
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameterList((PsiParameterList)this);
        }
    }
}

