/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiRecordComponentStub;
import com.intellij.psi.impl.java.stubs.impl.PsiRecordComponentStubImpl;
import com.intellij.psi.impl.source.PsiRecordComponentImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaRecordComponentElementType
extends JavaStubElementType<PsiRecordComponentStub, PsiRecordComponent> {
    public JavaRecordComponentElementType() {
        super("RECORD_COMPONENT");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new CompositeElement((IElementType)this);
    }

    public void serialize(@NotNull PsiRecordComponentStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getType(false));
        dataStream.writeByte((int)((PsiRecordComponentStubImpl)stub).getFlags());
    }

    @NotNull
    public PsiRecordComponentStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        String name2 = dataStream.readNameString();
        TypeInfo type2 = TypeInfo.readTYPE(dataStream);
        byte flags = dataStream.readByte();
        return new PsiRecordComponentStubImpl(parentStub, name2, type2, flags);
    }

    public void indexStub(@NotNull PsiRecordComponentStub stub, @NotNull IndexSink sink) {
    }

    public PsiRecordComponent createPsi(@NotNull PsiRecordComponentStub stub) {
        return this.getPsiFactory(stub).createRecordComponent(stub);
    }

    @Override
    public PsiRecordComponent createPsi(@NotNull ASTNode node) {
        return new PsiRecordComponentImpl(node);
    }

    @NotNull
    public PsiRecordComponentStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        TypeInfo typeInfo = TypeInfo.create(tree, node, parentStub);
        LighterASTNode id = LightTreeUtil.requiredChildOfType((LighterAST)tree, (LighterASTNode)node, (IElementType)JavaTokenType.IDENTIFIER);
        String name2 = RecordUtil.intern(tree.getCharTable(), id);
        LighterASTNode modifierList = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)node, (IElementType)JavaElementType.MODIFIER_LIST);
        boolean hasDeprecatedAnnotation = modifierList != null && RecordUtil.isDeprecatedByAnnotation(tree, modifierList);
        return new PsiRecordComponentStubImpl(parentStub, name2, typeInfo, typeInfo.isEllipsis, hasDeprecatedAnnotation);
    }
}

