/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiReferenceListImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaClassReferenceListElementType
extends JavaStubElementType<PsiClassReferenceListStub, PsiReferenceList> {
    public JavaClassReferenceListElementType(@NotNull String id) {
        super(id, true);
    }

    public PsiReferenceList createPsi(@NotNull PsiClassReferenceListStub stub) {
        return this.getPsiFactory(stub).createClassReferenceList(stub);
    }

    @Override
    public PsiReferenceList createPsi(@NotNull ASTNode node) {
        return new PsiReferenceListImpl(node);
    }

    @NotNull
    public PsiClassReferenceListStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        JavaClassReferenceListElementType type2 = (JavaClassReferenceListElementType)node.getTokenType();
        return new PsiClassReferenceListStubImpl(type2, parentStub, JavaClassReferenceListElementType.getTexts(tree, node));
    }

    private static String @NotNull [] getTexts(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        List refs = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)node, (IElementType)JavaElementType.JAVA_CODE_REFERENCE);
        String[] texts = ArrayUtil.newStringArray((int)refs.size());
        for (int i = 0; i < refs.size(); ++i) {
            texts[i] = LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)((LighterASTNode)refs.get(i)), null);
        }
        return texts;
    }

    public void serialize(@NotNull PsiClassReferenceListStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        String[] names2 = stub.getReferencedNames();
        dataStream.writeVarInt(names2.length);
        for (String name2 : names2) {
            dataStream.writeName(name2);
        }
    }

    @NotNull
    public PsiClassReferenceListStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        int len = dataStream.readVarInt();
        String[] names2 = ArrayUtil.newStringArray((int)len);
        for (int i = 0; i < names2.length; ++i) {
            names2[i] = dataStream.readNameString();
        }
        return new PsiClassReferenceListStubImpl(this, parentStub, names2);
    }

    public void indexStub(@NotNull PsiClassReferenceListStub stub, @NotNull IndexSink sink) {
        PsiReferenceList.Role role = stub.getRole();
        if (role == PsiReferenceList.Role.EXTENDS_LIST || role == PsiReferenceList.Role.IMPLEMENTS_LIST) {
            StubElement parentStub;
            String[] names2;
            for (String name2 : names2 = stub.getReferencedNames()) {
                String shortName = PsiNameHelper.getShortClassName((String)name2);
                if (StringUtil.isEmptyOrSpaces((String)shortName)) continue;
                sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, (Object)shortName);
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST && (parentStub = stub.getParentStub()) instanceof PsiClassStub) {
                PsiClassStub psiClassStub = (PsiClassStub)parentStub;
                if (psiClassStub.isEnum()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, (Object)"Enum");
                }
                if (psiClassStub.isAnnotationType()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, (Object)"Annotation");
                }
            }
        }
    }

    @NotNull
    public static PsiReferenceList.Role elementTypeToRole(@NotNull IElementType type2) {
        if (type2 == JavaStubElementTypes.EXTENDS_BOUND_LIST) {
            return PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
        }
        if (type2 == JavaStubElementTypes.EXTENDS_LIST) {
            return PsiReferenceList.Role.EXTENDS_LIST;
        }
        if (type2 == JavaStubElementTypes.IMPLEMENTS_LIST) {
            return PsiReferenceList.Role.IMPLEMENTS_LIST;
        }
        if (type2 == JavaStubElementTypes.THROWS_LIST) {
            return PsiReferenceList.Role.THROWS_LIST;
        }
        if (type2 == JavaStubElementTypes.PROVIDES_WITH_LIST) {
            return PsiReferenceList.Role.PROVIDES_WITH_LIST;
        }
        if (type2 == JavaStubElementTypes.PERMITS_LIST) {
            return PsiReferenceList.Role.PERMITS_LIST;
        }
        throw new RuntimeException("Unknown element type: " + type2);
    }
}

