/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.java.stubs.index.JavaAutoModuleNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSourceModuleNameIndex;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class JavaFileManagerImpl
implements JavaFileManager,
Disposable {
    private static final Logger LOG = Logger.getInstance(JavaFileManagerImpl.class);
    private final PsiManagerEx myManager;
    private volatile Set<String> myNontrivialPackagePrefixes;
    private boolean myDisposed;

    public JavaFileManagerImpl(Project project) {
        this.myManager = PsiManagerEx.getInstanceEx((Project)project);
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                JavaFileManagerImpl.this.myNontrivialPackagePrefixes = null;
            }
        });
    }

    public void dispose() {
        this.myDisposed = true;
    }

    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String packageName) {
        Query dirs = PackageIndex.getInstance((Project)this.myManager.getProject()).getDirsByPackageName(packageName, true);
        if (dirs.findFirst() == null) {
            return null;
        }
        return new PsiPackageImpl((PsiManager)this.myManager, packageName);
    }

    @Override
    public PsiClass @NotNull [] findClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        List<Pair<PsiClass, VirtualFile>> result = this.doFindClasses(qName, scope);
        int count = result.size();
        if (count == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        if (count == 1) {
            return new PsiClass[]{(PsiClass)result.get(0).getFirst()};
        }
        ContainerUtil.quickSort(result, (o1, o2) -> scope.compare((VirtualFile)o2.getSecond(), (VirtualFile)o1.getSecond()));
        return (PsiClass[])result.stream().map(p -> (PsiClass)p.getFirst()).toArray(PsiClass[]::new);
    }

    @NotNull
    private List<Pair<PsiClass, VirtualFile>> doFindClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        Collection<PsiClass> classes2 = JavaFullClassNameIndex.getInstance().get(qName.hashCode(), this.myManager.getProject(), scope);
        if (classes2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<PsiClass, VirtualFile>> result = new ArrayList<Pair<PsiClass, VirtualFile>>(classes2.size());
        for (PsiClass aClass : classes2) {
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.equals(qName)) continue;
            PsiFile file = aClass.getContainingFile();
            if (file == null) {
                throw new AssertionError((Object)("No file for class: " + aClass + " of " + aClass.getClass()));
            }
            VirtualFile vFile = file.getViewProvider().getVirtualFile();
            if (!this.hasAcceptablePackage(vFile)) continue;
            result.add((Pair<PsiClass, VirtualFile>)Pair.create((Object)aClass, (Object)vFile));
        }
        return result;
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        LOG.assertTrue(!this.myDisposed);
        VirtualFile bestFile = null;
        PsiClass bestClass = null;
        List<Pair<PsiClass, VirtualFile>> result = this.doFindClasses(qName, scope);
        for (int i = 0; i < result.size(); ++i) {
            Pair<PsiClass, VirtualFile> pair2 = result.get(i);
            VirtualFile vFile = (VirtualFile)pair2.getSecond();
            if (bestFile != null && scope.compare(vFile, bestFile) <= 0) continue;
            bestFile = vFile;
            bestClass = (PsiClass)pair2.getFirst();
        }
        return bestClass;
    }

    private boolean hasAcceptablePackage(@NotNull VirtualFile vFile) {
        if (FileTypeRegistry.getInstance().isFileOfType(vFile, (FileType)JavaClassFileType.INSTANCE)) {
            VirtualFile root = ProjectRootManager.getInstance((Project)this.myManager.getProject()).getFileIndex().getClassRootForFile(vFile);
            PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myManager.getProject());
            for (VirtualFile parent = vFile.getParent(); parent != null && !Comparing.equal((Object)parent, (Object)root); parent = parent.getParent()) {
                if (nameHelper.isIdentifier(parent.getName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<String> getNonTrivialPackagePrefixes() {
        Set<String> names2 = this.myNontrivialPackagePrefixes;
        if (names2 == null) {
            names2 = new HashSet<String>();
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)this.myManager.getProject());
            List sourceRoots = rootManager.getModuleSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            ProjectFileIndex fileIndex = rootManager.getFileIndex();
            for (VirtualFile sourceRoot : sourceRoots) {
                String packageName;
                if (!sourceRoot.isDirectory() || (packageName = fileIndex.getPackageNameByDirectory(sourceRoot)) == null || packageName.isEmpty()) continue;
                names2.add(packageName);
            }
            this.myNontrivialPackagePrefixes = names2;
        }
        return names2;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        LibSrcExcludingScope excludingScope = new LibSrcExcludingScope(scope);
        ArrayList<PsiJavaModule> results = new ArrayList<PsiJavaModule>(JavaModuleNameIndex.getInstance().get(moduleName, this.myManager.getProject(), (GlobalSearchScope)excludingScope));
        for (VirtualFile manifest : JavaSourceModuleNameIndex.getFilesByKey(moduleName, (GlobalSearchScope)excludingScope)) {
            ContainerUtil.addIfNotNull(results, (Object)((Object)LightJavaModule.findModule((PsiManager)this.myManager, manifest.getParent().getParent())));
        }
        for (VirtualFile root : JavaAutoModuleNameIndex.getFilesByKey(moduleName, (GlobalSearchScope)excludingScope)) {
            ContainerUtil.addIfNotNull(results, (Object)((Object)LightJavaModule.findModule((PsiManager)this.myManager, root)));
        }
        return JavaFileManagerImpl.upgradeModules(JavaFileManagerImpl.sortModules(results, scope), moduleName, scope);
    }

    private static Collection<PsiJavaModule> sortModules(Collection<PsiJavaModule> modules, GlobalSearchScope scope) {
        if (modules.size() > 1) {
            ArrayList<PsiJavaModule> list = new ArrayList<PsiJavaModule>(modules);
            list.sort((m1, m2) -> scope.compare(PsiImplUtil.getModuleVirtualFile(m2), PsiImplUtil.getModuleVirtualFile(m1)));
            modules = list;
        }
        return modules;
    }

    private static Collection<PsiJavaModule> upgradeModules(Collection<PsiJavaModule> modules, String moduleName, GlobalSearchScope scope) {
        if (modules.size() > 1 && PsiJavaModule.UPGRADEABLE.contains(moduleName) && scope instanceof ModuleWithDependenciesScope) {
            Module module = ((ModuleWithDependenciesScope)scope).getModule();
            boolean isModular = Stream.of(ModuleRootManager.getInstance((Module)module).getSourceRoots(true)).filter(arg_0 -> ((GlobalSearchScope)scope).contains(arg_0)).anyMatch(root -> root.findChild("module-info.java") != null);
            if (isModular) {
                List<PsiJavaModule> list = new ArrayList<PsiJavaModule>(modules);
                ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
                ListIterator i = list.listIterator();
                while (i.hasNext()) {
                    PsiJavaModule candidate = (PsiJavaModule)i.next();
                    if (!(index.getOrderEntryForFile(PsiImplUtil.getModuleVirtualFile(candidate)) instanceof JdkOrderEntry)) continue;
                    if (i.previousIndex() > 0) {
                        i.remove();
                        continue;
                    }
                    list = Collections.singletonList(candidate);
                    break;
                }
                if (list.size() != modules.size()) {
                    modules = list;
                }
            }
        }
        return modules;
    }

    private static class LibSrcExcludingScope
    extends DelegatingGlobalSearchScope {
        private final ProjectFileIndex myIndex;

        LibSrcExcludingScope(@NotNull GlobalSearchScope baseScope) {
            super(baseScope);
            this.myIndex = ProjectFileIndex.getInstance((Project)Objects.requireNonNull(baseScope.getProject()));
        }

        public boolean contains(@NotNull VirtualFile file) {
            return super.contains(file) && (!this.myIndex.isInLibrarySource(file) || this.myIndex.isInLibraryClasses(file));
        }
    }
}

