/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ClsParameterImpl
extends ClsRepositoryPsiElement<PsiParameterStub>
implements PsiParameter {
    private final NotNullLazyValue<PsiTypeElement> myType = new AtomicNotNullLazyValue<PsiTypeElement>(){

        @NotNull
        protected PsiTypeElement compute() {
            PsiParameterStub stub = (PsiParameterStub)ClsParameterImpl.this.getStub();
            String typeText = TypeInfo.createTypeText(stub.getType(false));
            assert (typeText != null) : stub;
            return new ClsTypeElementImpl((PsiElement)ClsParameterImpl.this, typeText, '\u0000');
        }
    };
    private volatile String myMirrorName;

    public ClsParameterImpl(@NotNull PsiParameterStub stub) {
        super(stub);
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @NotNull
    public String getName() {
        return (String)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcName(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    private String calcName() {
        PsiParameterStubImpl parameterStub = (PsiParameterStubImpl)this.getStub();
        if (!parameterStub.isAutoGeneratedName()) {
            return parameterStub.getName();
        }
        ClsMethodImpl method = (ClsMethodImpl)this.getDeclarationScope();
        PsiMethod sourceMethod = method.getSourceMirrorMethod();
        if (sourceMethod != null) {
            assert (sourceMethod != method) : method;
            return sourceMethod.getParameterList().getParameters()[this.getIndex()].getName();
        }
        return this.getMirrorName();
    }

    public boolean isAutoGeneratedName() {
        return ((PsiParameterStubImpl)this.getStub()).isAutoGeneratedName() && ((ClsMethodImpl)this.getDeclarationScope()).getSourceMirrorMethod() == null;
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        throw ClsParameterImpl.cannotModifyException(this);
    }

    @NotNull
    public PsiTypeElement getTypeElement() {
        return (PsiTypeElement)this.myType.getValue();
    }

    @NotNull
    public PsiType getType() {
        return this.getTypeElement().getType();
    }

    @NotNull
    public PsiModifierList getModifierList() {
        StubElement child = ((PsiParameterStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        assert (child != null);
        return (PsiModifierList)child.getPsi();
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        return this.getModifierList().hasModifierProperty(name2);
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public Object computeConstantValue() {
        return null;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        PsiAnnotation[] annotations;
        for (PsiAnnotation annotation : annotations = this.getModifierList().getAnnotations()) {
            ClsParameterImpl.appendText((PsiElement)annotation, indentLevel, buffer);
            buffer.append(' ');
        }
        ClsParameterImpl.appendText((PsiElement)this.getTypeElement(), indentLevel, buffer, " ");
        buffer.append(this.getMirrorName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String getMirrorName() {
        String mirrorName = this.myMirrorName;
        if (mirrorName == null) {
            PsiElement psiElement = this.getParent();
            synchronized (psiElement) {
                mirrorName = this.myMirrorName;
                if (mirrorName == null) {
                    this.myMirrorName = mirrorName = this.calcNiceParameterName();
                }
            }
        }
        return mirrorName;
    }

    @NotNull
    private String calcNiceParameterName() {
        String name2 = null;
        PsiParameterStubImpl stub = (PsiParameterStubImpl)this.getStub();
        if (!stub.isAutoGeneratedName()) {
            name2 = stub.getName();
        }
        if (name2 == null) {
            String base = name2 = StringUtil.notNullize((String)JavaCodeStyleManager.getInstance((Project)this.getProject()).suggestCompiledParameterName(this.getType()), (String)"p");
            int n = 0;
            block0: while (true) {
                PsiParameter[] psiParameterArray = ((PsiParameterList)this.getParent()).getParameters();
                int n2 = psiParameterArray.length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) continue block0;
                    PsiParameter parameter2 = psiParameterArray[n3];
                    if (parameter2 == this) break block0;
                    String prevName = ((ClsParameterImpl)parameter2).getMirrorName();
                    if (name2.equals(prevName)) {
                        name2 = base + ++n;
                        continue block0;
                    }
                    ++n3;
                }
                break;
            }
        }
        return name2;
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, null);
        PsiParameter mirror = (PsiParameter)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element);
        ClsParameterImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsParameterImpl.setMirror(this.getTypeElement(), mirror.getTypeElement());
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameter((PsiParameter)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        return this.getParent().getParent();
    }

    private int getIndex() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        return stub.getParentStub().getChildrenStubs().indexOf(stub);
    }

    public boolean isVarArgs() {
        PsiParameterList paramList = (PsiParameterList)this.getParent();
        PsiMethod method = (PsiMethod)paramList.getParent();
        return method.isVarArgs() && this.getIndex() == paramList.getParametersCount() - 1;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, PlatformIcons.PARAMETER_ICON, 0);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @NotNull
    public SearchScope getUseScope() {
        return new LocalSearchScope(this.getDeclarationScope());
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiParameter[] psiParameters;
        PsiMethod psiMethod;
        int index;
        PsiMethod clsMethod;
        PsiParameterList list = (PsiParameterList)ObjectUtils.tryCast((Object)this.getParent(), PsiParameterList.class);
        if (list != null && (clsMethod = (PsiMethod)ObjectUtils.tryCast((Object)list.getParent(), PsiMethod.class)) != null && (index = ArrayUtil.indexOf((Object[])list.getParameters(), (Object)((Object)this))) >= 0 && (psiMethod = (PsiMethod)ObjectUtils.tryCast((Object)clsMethod.getNavigationElement(), PsiMethod.class)) != null && psiMethod != clsMethod && (psiParameters = psiMethod.getParameterList().getParameters()).length > index) {
            return psiParameters[index];
        }
        return this;
    }

    public String toString() {
        return "PsiParameter";
    }
}

