/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecaptureTypeMapper
extends PsiTypeMapper {
    public static final Key<PsiElement> SELF_REFERENCE = Key.create((String)"SELF_REFERENCE");
    private final Set<PsiClassType> myVisited = ContainerUtil.newIdentityTroveSet();

    @Override
    public PsiType visitType(@NotNull PsiType type2) {
        return type2;
    }

    @Override
    public PsiType visitClassType(@NotNull PsiClassType classType) {
        if (!this.myVisited.add(classType)) {
            return classType;
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
        if (psiClass == null) {
            return classType;
        }
        return new PsiImmediateClassType(psiClass, this.recapture(substitutor));
    }

    public PsiSubstitutor recapture(PsiSubstitutor substitutor) {
        PsiSubstitutor result = PsiSubstitutor.EMPTY;
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            PsiType value2 = (PsiType)entry.getValue();
            result = result.put((PsiTypeParameter)entry.getKey(), value2 == null ? null : this.mapType(value2));
        }
        return result;
    }

    @Override
    public PsiType visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
        PsiElement context = capturedWildcardType.getContext();
        @Nullable PsiElement original = (PsiElement)context.getCopyableUserData(SELF_REFERENCE);
        if (original != null) {
            context = original;
        }
        PsiCapturedWildcardType mapped = PsiCapturedWildcardType.create((PsiWildcardType)capturedWildcardType.getWildcard(), (PsiElement)context, (PsiTypeParameter)capturedWildcardType.getTypeParameter());
        mapped.setUpperBound((PsiType)capturedWildcardType.getUpperBound(false).accept((PsiTypeVisitor)this));
        return mapped;
    }

    public static void encode(PsiElement expression2) {
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element instanceof PsiExpression) {
                    element.putCopyableUserData(SELF_REFERENCE, (Object)element);
                }
                super.visitElement(element);
            }
        });
    }

    public static void clean(PsiElement expression2) {
        expression2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element instanceof PsiExpression) {
                    element.putCopyableUserData(SELF_REFERENCE, null);
                }
                super.visitElement(element);
            }
        });
    }
}

