/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.RecaptureTypeMapper;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class PsiDiamondTypeUtil {
    private static final Logger LOG = Logger.getInstance(PsiDiamondTypeUtil.class);

    private PsiDiamondTypeUtil() {
    }

    public static boolean canCollapseToDiamond(PsiNewExpression expression2, PsiNewExpression context, @Nullable PsiType expectedType) {
        return PsiDiamondTypeUtil.canCollapseToDiamond(expression2, context, expectedType, false);
    }

    public static boolean canChangeContextForDiamond(PsiNewExpression expression2, PsiType expectedType) {
        PsiNewExpression copy = (PsiNewExpression)expression2.copy();
        return PsiDiamondTypeUtil.canCollapseToDiamond(copy, copy, expectedType, true);
    }

    private static boolean canCollapseToDiamond(PsiNewExpression expression2, PsiNewExpression context, @Nullable PsiType expectedType, boolean skipDiamonds) {
        PsiTypeElement[] typeElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference2;
        if (PsiUtil.getLanguageLevel((PsiElement)context).isAtLeast(LanguageLevel.JDK_1_7) && (classReference2 = expression2.getClassOrAnonymousClassReference()) != null && (parameterList = classReference2.getParameterList()) != null && (typeElements = parameterList.getTypeParameterElements()).length > 0) {
            if (!skipDiamonds && typeElements.length == 1 && typeElements[0].getType() instanceof PsiDiamondType) {
                return false;
            }
            PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypes(expression2, (PsiElement)context);
            if (inferenceResult.getErrorMessage() == null) {
                List types = inferenceResult.getInferredTypes();
                PsiType[] typeArguments = null;
                if (expectedType instanceof PsiClassType) {
                    typeArguments = ((PsiClassType)expectedType).getParameters();
                }
                if (typeArguments == null) {
                    typeArguments = parameterList.getTypeArguments();
                }
                if (types.size() == typeArguments.length) {
                    PsiMethod method = expression2.resolveMethod();
                    PsiElement resolve2 = classReference2.resolve();
                    if (resolve2 instanceof PsiClass) {
                        PsiTypeParameter[] typeParameters = ((PsiClass)resolve2).getTypeParameters();
                        return PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments, (PsiExpression)context, true, method, typeParameters);
                    }
                }
            }
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    public static PsiElement replaceExplicitWithDiamond(PsiElement psiElement) {
        PsiElement replacement = PsiDiamondTypeUtil.createExplicitReplacement(psiElement);
        return replacement == null ? psiElement : psiElement.replace(replacement);
    }

    public static PsiElement createExplicitReplacement(PsiElement psiElement) {
        if (psiElement instanceof PsiReferenceParameterList) {
            PsiNewExpression expression2 = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)psiElement.getProject()).createExpressionFromText("new a<>()", psiElement);
            PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
            LOG.assertTrue(classReference2 != null);
            PsiReferenceParameterList parameterList = classReference2.getParameterList();
            LOG.assertTrue(parameterList != null);
            return parameterList;
        }
        return null;
    }

    public static PsiElement replaceDiamondWithExplicitTypes(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return parent;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)parent;
        PsiReferenceParameterList parameterList = javaCodeReferenceElement.getParameterList();
        if (parameterList == null) {
            return javaCodeReferenceElement;
        }
        StringBuilder text2 = new StringBuilder();
        text2.append(javaCodeReferenceElement.getQualifiedName());
        text2.append('<');
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
        PsiDiamondType.DiamondInferenceResult result = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, (PsiElement)newExpression);
        text2.append(StringUtil.join((Collection)result.getInferredTypes(), psiType -> psiType.getCanonicalText(), (String)","));
        text2.append('>');
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(text2.toString(), element);
        PsiReferenceParameterList newReferenceParameterList = newReference.getParameterList();
        LOG.assertTrue(newReferenceParameterList != null);
        CodeStyleManager.getInstance((Project)javaCodeReferenceElement.getProject()).reformat(parameterList.replace((PsiElement)newReferenceParameterList));
        return javaCodeReferenceElement;
    }

    public static PsiExpression expandTopLevelDiamondsInside(PsiExpression expr2) {
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference2;
        if (expr2 instanceof PsiNewExpression && (classReference2 = ((PsiNewExpression)expr2).getClassReference()) != null && (parameterList = classReference2.getParameterList()) != null && (typeParameterElements = parameterList.getTypeParameterElements()).length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType) {
            return (PsiExpression)PsiDiamondTypeUtil.replaceDiamondWithExplicitTypes((PsiElement)parameterList).getParent();
        }
        return expr2;
    }

    public static String getCollapsedType(PsiType type2, PsiElement context) {
        int idx;
        String typeText = type2.getCanonicalText();
        if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)context) && (idx = typeText.indexOf(60)) >= 0) {
            return typeText.substring(0, idx) + "<>";
        }
        return typeText;
    }

    private static boolean isAugmented(PsiExpression expression2) {
        PsiElement gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        PsiTypeElement typeElement = null;
        if (gParent instanceof PsiVariable) {
            typeElement = ((PsiVariable)gParent).getTypeElement();
        } else if (gParent instanceof PsiReturnStatement) {
            PsiElement method = PsiTreeUtil.getParentOfType((PsiElement)gParent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            typeElement = method instanceof PsiMethod ? ((PsiMethod)method).getReturnTypeElement() : null;
        }
        return typeElement != null && PsiAugmentProvider.getInferredType((PsiTypeElement)typeElement) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean areTypeArgumentsRedundant(PsiType[] typeArguments, PsiExpression context, boolean constructorRef, @Nullable PsiMethod method, PsiTypeParameter[] typeParameters) {
        PsiExpression encoded;
        block39: {
            boolean bl;
            block38: {
                boolean elementFactory2;
                block37: {
                    boolean call222;
                    block36: {
                        boolean call222;
                        block35: {
                            boolean call222;
                            block34: {
                                boolean bl2;
                                block33: {
                                    boolean bl3;
                                    block32: {
                                        boolean bl4;
                                        block31: {
                                            encoded = null;
                                            try {
                                                PsiElement copy;
                                                PsiType typeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)context);
                                                if (typeByParent != null && PsiTypesUtil.isDenotableType((PsiType)typeByParent, (PsiElement)context)) {
                                                    if (PsiDiamondTypeUtil.isAugmented(context)) {
                                                        bl4 = false;
                                                        if (encoded == null) return bl4;
                                                        break block31;
                                                    }
                                                    encoded = context;
                                                    RecaptureTypeMapper.encode((PsiElement)encoded);
                                                    copy = LambdaUtil.copyWithExpectedType((PsiElement)context, (PsiType)typeByParent);
                                                } else {
                                                    PsiExpressionList argumentList = context instanceof PsiCallExpression ? ((PsiCallExpression)context).getArgumentList() : null;
                                                    Object marker = new Object();
                                                    PsiTreeUtil.mark((PsiElement)(argumentList != null ? argumentList : context), (Object)marker);
                                                    PsiCall call222 = LambdaUtil.treeWalkUp((PsiElement)context);
                                                    if (call222 != null) {
                                                        encoded = call222;
                                                        RecaptureTypeMapper.encode((PsiElement)encoded);
                                                        PsiCall callCopy = LambdaUtil.copyTopLevelCall((PsiCall)call222);
                                                        copy = callCopy != null ? PsiTreeUtil.releaseMark((PsiElement)callCopy, (Object)marker) : null;
                                                    } else {
                                                        PsiElement startMethodElementInCopy;
                                                        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)context.getProject());
                                                        if (injectedLanguageManager.getInjectionHost((PsiElement)context) != null) {
                                                            bl3 = false;
                                                            if (encoded == null) return bl3;
                                                            break block32;
                                                        }
                                                        PsiFile containingFile = context.getContainingFile();
                                                        PsiFile fileCopy = (PsiFile)containingFile.copy();
                                                        copy = PsiTreeUtil.releaseMark((PsiElement)fileCopy, (Object)marker);
                                                        if (method != null && method.getContainingFile() == containingFile && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(startMethodElementInCopy = fileCopy.findElementAt(method.getTextOffset())), PsiMethod.class)) == null) {
                                                            bl2 = false;
                                                            if (encoded == null) return bl2;
                                                            break block33;
                                                        }
                                                    }
                                                }
                                                PsiCallExpression exprCopy = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)copy, PsiCallExpression.class, (boolean)false);
                                                if (context instanceof PsiMethodReferenceExpression) {
                                                    PsiMethodReferenceExpression methodRefCopy = (PsiMethodReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)copy, PsiMethodReferenceExpression.class, (boolean)false);
                                                    if (methodRefCopy != null && !PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, typeParameters, method, methodRefCopy)) {
                                                        call222 = false;
                                                        if (encoded == null) return call222;
                                                        break block34;
                                                    }
                                                } else if (exprCopy != null) {
                                                    PsiElementFactory elementFactory2 = JavaPsiFacade.getElementFactory((Project)exprCopy.getProject());
                                                    if (constructorRef) {
                                                        if (!(exprCopy instanceof PsiNewExpression) || !PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, elementFactory2, (PsiNewExpression)exprCopy)) {
                                                            call222 = false;
                                                            if (encoded == null) return call222;
                                                            break block35;
                                                        }
                                                    } else {
                                                        LOG.assertTrue(method != null);
                                                        if (!PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments, elementFactory2, exprCopy, method, typeParameters)) {
                                                            call222 = false;
                                                            if (encoded == null) return call222;
                                                            break block36;
                                                        }
                                                    }
                                                }
                                                if (typeByParent != null) {
                                                    elementFactory2 = true;
                                                    if (encoded == null) return elementFactory2;
                                                    break block37;
                                                }
                                                PsiCallExpression newParentCall = exprCopy != null ? (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)exprCopy, PsiCallExpression.class) : null;
                                                PsiCallExpression oldParentCall = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiCallExpression.class);
                                                if (newParentCall != null && oldParentCall != null) {
                                                    JavaResolveResult newResult = newParentCall.resolveMethodGenerics();
                                                    JavaResolveResult oldResult = oldParentCall.resolveMethodGenerics();
                                                    if (!Objects.equals(newResult.getElement(), oldResult.getElement()) || !new RecaptureTypeMapper().recapture(newResult.getSubstitutor()).equals(oldResult.getSubstitutor())) {
                                                        bl = false;
                                                        if (encoded == null) return bl;
                                                        break block38;
                                                    }
                                                }
                                                if (encoded == null) return true;
                                                break block39;
                                            }
                                            catch (IncorrectOperationException e) {
                                                LOG.info((Throwable)e);
                                                boolean bl5 = false;
                                                return bl5;
                                            }
                                        }
                                        RecaptureTypeMapper.clean((PsiElement)encoded);
                                        return bl4;
                                    }
                                    RecaptureTypeMapper.clean((PsiElement)encoded);
                                    return bl3;
                                }
                                RecaptureTypeMapper.clean((PsiElement)encoded);
                                return bl2;
                            }
                            RecaptureTypeMapper.clean((PsiElement)encoded);
                            return call222;
                        }
                        RecaptureTypeMapper.clean((PsiElement)encoded);
                        return call222;
                    }
                    RecaptureTypeMapper.clean((PsiElement)encoded);
                    return call222;
                }
                RecaptureTypeMapper.clean((PsiElement)encoded);
                return elementFactory2;
            }
            RecaptureTypeMapper.clean((PsiElement)encoded);
            return bl;
        }
        RecaptureTypeMapper.clean((PsiElement)encoded);
        return true;
        finally {
            if (encoded != null) {
                RecaptureTypeMapper.clean(encoded);
            }
        }
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiTypeParameter[] typeParameters, PsiMethod method, PsiMethodReferenceExpression methodRefCopy) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)methodRefCopy.getProject());
        PsiTypeElement qualifierType = methodRefCopy.getQualifierType();
        if (qualifierType != null) {
            qualifierType.replace((PsiElement)elementFactory.createTypeElement((PsiType)((PsiClassType)qualifierType.getType()).rawType()));
        } else {
            PsiReferenceParameterList parameterList = methodRefCopy.getParameterList();
            if (parameterList != null) {
                parameterList.delete();
            }
        }
        JavaResolveResult result = methodRefCopy.advancedResolve(false);
        if (method != null && result.getElement() != method) {
            return false;
        }
        PsiSubstitutor psiSubstitutor = result.getSubstitutor();
        for (int i = 0; i < typeParameters.length; ++i) {
            PsiTypeParameter typeParameter = typeParameters[i];
            PsiType inferredType = (PsiType)psiSubstitutor.getSubstitutionMap().get(typeParameter);
            if (typeArguments[i].equals(inferredType)) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability((PsiExpression)methodRefCopy);
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiElementFactory elementFactory, PsiCallExpression exprCopy, PsiMethod method, PsiTypeParameter[] typeParameters) throws IncorrectOperationException {
        PsiReferenceParameterList list = ((PsiCallExpression)elementFactory.createExpressionFromText("foo()", null)).getTypeArgumentList();
        exprCopy.getTypeArgumentList().replace((PsiElement)list);
        JavaResolveResult copyResult = exprCopy.resolveMethodGenerics();
        if (method != copyResult.getElement()) {
            return false;
        }
        PsiSubstitutor psiSubstitutor = copyResult.getSubstitutor();
        int length = typeParameters.length;
        for (int i = 0; i < length; ++i) {
            PsiTypeParameter typeParameter = typeParameters[i];
            PsiType inferredType = (PsiType)psiSubstitutor.getSubstitutionMap().get(typeParameter);
            if (!typeArguments[i].equals(inferredType)) {
                return false;
            }
            if (PsiUtil.resolveClassInType((PsiType)method.getReturnType()) != typeParameter || PsiPrimitiveType.getUnboxedType((PsiType)inferredType) == null) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability((PsiExpression)exprCopy);
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments, PsiElementFactory elementFactory, PsiNewExpression exprCopy) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement collapsedClassReference = ((PsiNewExpression)elementFactory.createExpressionFromText("new A<>()", null)).getClassOrAnonymousClassReference();
        LOG.assertTrue(collapsedClassReference != null);
        PsiReferenceParameterList diamondParameterList = collapsedClassReference.getParameterList();
        LOG.assertTrue(diamondParameterList != null);
        PsiJavaCodeReferenceElement classReference2 = exprCopy.getClassOrAnonymousClassReference();
        LOG.assertTrue(classReference2 != null);
        PsiReferenceParameterList parameterList = classReference2.getParameterList();
        LOG.assertTrue(parameterList != null);
        parameterList.replace((PsiElement)diamondParameterList);
        PsiType[] inferredArgs = classReference2.getParameterList().getTypeArguments();
        if (typeArguments.length != inferredArgs.length) {
            return false;
        }
        for (int i = 0; i < typeArguments.length; ++i) {
            PsiWildcardType wildcardType;
            PsiType bound;
            PsiType typeArgument = typeArguments[i];
            if (inferredArgs[i] instanceof PsiWildcardType && (bound = (wildcardType = (PsiWildcardType)inferredArgs[i]).getBound()) != null && (!wildcardType.isExtends() ? typeArgument.isAssignableFrom(bound) : bound.isAssignableFrom(typeArgument)) || typeArgument.equals(inferredArgs[i])) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability((PsiExpression)exprCopy);
    }

    private static boolean checkParentApplicability(PsiExpression exprCopy) {
        while (exprCopy != null) {
            JavaResolveResult resolveResult;
            JavaResolveResult javaResolveResult = resolveResult = exprCopy instanceof PsiCallExpression ? PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((PsiCall)exprCopy)) : null;
            if (resolveResult instanceof MethodCandidateInfo && !((MethodCandidateInfo)resolveResult).isApplicable()) {
                return false;
            }
            exprCopy = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)exprCopy, PsiCallExpression.class, (boolean)true);
        }
        return true;
    }
}

