/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeShortNamesCache
extends PsiShortNamesCache {
    private final Project myProject;

    public CompositeShortNamesCache(Project project) {
        this.myProject = project;
    }

    @NotNull
    private List<PsiShortNamesCache> getCaches() {
        return this.myProject.isDefault() ? Collections.emptyList() : PsiShortNamesCache.EP_NAME.getExtensionList((AreaInstance)this.myProject);
    }

    public PsiFile @NotNull [] getFilesByName(@NotNull String name2) {
        Merger<PsiFile> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiFile[] classes2 = cache.getFilesByName(name2);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiFile>();
            }
            merger.add(classes2);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiFile.EMPTY_ARRAY);
    }

    public String @NotNull [] getAllFileNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.getCaches()) {
            merger.add(cache.getAllFileNames());
        }
        return CompositeShortNamesCache.getMergerResult(merger, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    private static <T> T @NotNull [] getMergerResult(@Nullable Merger<T> merger, T[] emptyArray) {
        if (merger == null || ((Merger)merger).myAllItems == null && ((Merger)merger).mySingleItem == null) {
            return emptyArray;
        }
        return ((Merger)merger).myAllItems == null ? ((Merger)merger).mySingleItem : ((Merger)merger).myAllItems.toArray(emptyArray);
    }

    public PsiClass @NotNull [] getClassesByName(@NotNull String name2, @NotNull GlobalSearchScope scope) {
        Merger<PsiClass> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiClass[] classes2 = cache.getClassesByName(name2, scope);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiClass>();
            }
            merger.add(classes2);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiClass.EMPTY_ARRAY);
    }

    public String @NotNull [] getAllClassNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.getCaches()) {
            String[] names2 = cache.getAllClassNames();
            merger.add(names2);
        }
        return CompositeShortNamesCache.getMergerResult(merger, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor2) {
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor2);
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllClassNames((Processor)uniqueProcessor)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllClassNames(processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllMethodNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllMethodNames(processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllFieldNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllFieldNames(processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public PsiMethod @NotNull [] getMethodsByName(@NotNull String name2, @NotNull GlobalSearchScope scope) {
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiMethod[] methods = cache.getMethodsByName(name2, scope);
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiMethod.EMPTY_ARRAY);
    }

    public PsiMethod @NotNull [] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name2, @NotNull GlobalSearchScope scope, int maxCount) {
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiMethod[] methods = cache.getMethodsByNameIfNotMoreThan(name2, scope, maxCount);
            if (methods.length == maxCount) {
                return methods;
            }
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiMethod.EMPTY_ARRAY);
    }

    public PsiField @NotNull [] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name2, @NotNull GlobalSearchScope scope, int maxCount) {
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiField[] fields = cache.getFieldsByNameIfNotMoreThan(name2, scope, maxCount);
            if (fields.length == maxCount) {
                return fields;
            }
            if (fields.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(fields);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiField.EMPTY_ARRAY);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name2, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiMethod> processor2) {
        return this.processMethodsWithName(name2, processor2, scope, null);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name2, @NotNull Processor<? super PsiMethod> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processMethodsWithName(name2, processor2, scope, idFilter)) continue;
            return false;
        }
        return true;
    }

    public String @NotNull [] getAllMethodNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.getCaches()) {
            merger.add(cache.getAllMethodNames());
        }
        return CompositeShortNamesCache.getMergerResult(merger, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public PsiField @NotNull [] getFieldsByName(@NotNull String name2, @NotNull GlobalSearchScope scope) {
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiField[] classes2 = cache.getFieldsByName(name2, scope);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(classes2);
        }
        return CompositeShortNamesCache.getMergerResult(merger, PsiField.EMPTY_ARRAY);
    }

    public String @NotNull [] getAllFieldNames() {
        Merger<String> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            String[] classes2 = cache.getAllFieldNames();
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<String>();
            }
            merger.add(classes2);
        }
        return CompositeShortNamesCache.getMergerResult(merger, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public boolean processFieldsWithName(@NotNull String key2, @NotNull Processor<? super PsiField> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processFieldsWithName(key2, processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processClassesWithName(@NotNull String key2, @NotNull Processor<? super PsiClass> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processClassesWithName(key2, processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Composite cache: " + Collections.singletonList(this.getCaches());
    }

    private static class Merger<T> {
        private T[] mySingleItem;
        private Set<T> myAllItems;

        private Merger() {
        }

        void add(T @NotNull [] items) {
            if (items.length == 0) {
                return;
            }
            if (this.mySingleItem == null) {
                this.mySingleItem = items;
                return;
            }
            if (this.myAllItems == null) {
                Object[] elements = this.mySingleItem;
                this.myAllItems = (Set)ContainerUtil.addAll((Collection)new THashSet(elements.length), (Object[])elements);
            }
            ContainerUtil.addAll(this.myAllItems, (Object[])items);
        }
    }
}

