/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockBuilder;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.LeafBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CommentWithInjectionBlock
extends AbstractJavaBlock {
    private final InjectedLanguageBlockBuilder myInjectedBlockBuilder = new JavaCommentInjectedBlockBuilder();

    public CommentWithInjectionBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        super(node, wrap, alignment, indent, settings, javaSettings, formattingMode);
    }

    protected List<Block> buildChildren() {
        ArrayList<Block> result = new ArrayList<Block>();
        this.myInjectedBlockBuilder.addInjectedBlocks(result, this.myNode, this.myWrap, this.myAlignment, Indent.getNoneIndent());
        return result;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(Indent.getNormalIndent(), null);
    }

    @Override
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        return null;
    }

    private static class PartialCommentBlock
    extends LeafBlock {
        private final TextRange myRange;

        PartialCommentBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
            super(node, wrap, alignment, indent);
            this.myRange = range;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            return this.myRange;
        }
    }

    private class JavaCommentInjectedBlockBuilder
    extends InjectedLanguageBlockBuilder {
        private JavaCommentInjectedBlockBuilder() {
        }

        public CodeStyleSettings getSettings() {
            return CommentWithInjectionBlock.this.mySettings.getRootSettings();
        }

        public boolean canProcessFragment(String text2, ASTNode injectionHost) {
            return true;
        }

        public Block createBlockBeforeInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
            return new PartialCommentBlock(node, wrap, alignment, indent, range);
        }

        public Block createBlockAfterInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range) {
            return new PartialCommentBlock(node, wrap, alignment, Indent.getNoneIndent(), range);
        }
    }
}

