/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class LocalsOrMyInstanceFieldsControlFlowPolicy
implements ControlFlowPolicy {
    private static final LocalsOrMyInstanceFieldsControlFlowPolicy INSTANCE = new LocalsOrMyInstanceFieldsControlFlowPolicy();

    private LocalsOrMyInstanceFieldsControlFlowPolicy() {
    }

    @Override
    public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
        if (LocalsOrMyInstanceFieldsControlFlowPolicy.isLocalOrMyInstanceReference(refExpr)) {
            return (PsiVariable)ObjectUtils.tryCast((Object)refExpr.resolve(), PsiVariable.class);
        }
        return null;
    }

    @Override
    public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
        return true;
    }

    @Override
    public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
        return true;
    }

    public static LocalsOrMyInstanceFieldsControlFlowPolicy getInstance() {
        return INSTANCE;
    }

    public static boolean isLocalOrMyInstanceReference(PsiReferenceExpression variableReference) {
        PsiExpression qualifierExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)variableReference.getQualifierExpression());
        return qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression && ((PsiThisExpression)qualifierExpression2).getQualifier() == null;
    }
}

