/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenProcessorBase;
import com.intellij.projectImport.ProjectOpenProcessorBaseKt;
import com.intellij.projectImport.ProjectOpenedCallback;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \"*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001\"B\u000f\b\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\r\u0010\u0014\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\bJ$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020\rH\u0016J\"\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0004\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/intellij/projectImport/ProjectOpenProcessorBase;", "T", "Lcom/intellij/projectImport/ProjectImportBuilder;", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "builder", "(Lcom/intellij/projectImport/ProjectImportBuilder;)V", "()V", "getBuilder", "()Lcom/intellij/projectImport/ProjectImportBuilder;", "myBuilder", "Lcom/intellij/projectImport/ProjectImportBuilder;", "supportedExtensions", "", "", "getSupportedExtensions", "()[Ljava/lang/String;", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "doGetBuilder", "doOpenProject", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "doQuickImport", "wizardContext", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "getIcon", "Ljavax/swing/Icon;", "getName", "importToProject", "projectToOpen", "Companion", "intellij.java.ui"})
public abstract class ProjectOpenProcessorBase<T extends ProjectImportBuilder<?>>
extends ProjectOpenProcessor {
    private final T myBuilder;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public T getBuilder() {
        return this.doGetBuilder();
    }

    @NotNull
    protected T doGetBuilder() {
        T t = this.myBuilder;
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    @NotNull
    public String getName() {
        return ((ProjectImportBuilder)((Object)this.getBuilder())).getName();
    }

    @Nullable
    public Icon getIcon() {
        return ((ProjectImportBuilder)((Object)this.getBuilder())).getIcon();
    }

    public boolean canOpenProject(@NotNull VirtualFile file) {
        String[] supported = this.getSupportedExtensions();
        if (file.isDirectory()) {
            boolean bl;
            block2: {
                VirtualFile[] $this$any$iv = ProjectOpenProcessorBaseKt.access$getFileChildren(file);
                boolean $i$f$any = false;
                VirtualFile[] virtualFileArray = $this$any$iv;
                int n = virtualFileArray.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile element$iv;
                    VirtualFile it = element$iv = virtualFileArray[i];
                    boolean bl2 = false;
                    if (!Companion.canOpenFile(it, supported)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }
        return Companion.canOpenFile(file, supported);
    }

    protected boolean doQuickImport(@NotNull VirtualFile file, @NotNull WizardContext wizardContext) {
        return false;
    }

    @NotNull
    public abstract String[] getSupportedExtensions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        try {
            Sdk sdk;
            String[] supported;
            WizardContext wizardContext = new WizardContext(null, null);
            ((ProjectImportBuilder)((Object)this.getBuilder())).setUpdate(false);
            VirtualFile resolvedVirtualFile = virtualFile;
            if (virtualFile.isDirectory()) {
                supported = this.getSupportedExtensions();
                for (VirtualFile file : ProjectOpenProcessorBaseKt.access$getFileChildren(virtualFile)) {
                    if (!Companion.canOpenFile(file, supported)) continue;
                    resolvedVirtualFile = file;
                    break;
                }
            }
            wizardContext.setProjectFileDirectory(resolvedVirtualFile.getParent().toNioPath(), false);
            if (!this.doQuickImport(resolvedVirtualFile, wizardContext)) {
                supported = null;
                return supported;
            }
            if (wizardContext.getProjectName() == null) {
                if (wizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT) {
                    wizardContext.setProjectName(JavaUiBundle.message("project.import.default.name", this.getName()) + ".ipr");
                } else {
                    wizardContext.setProjectName(JavaUiBundle.message("project.import.default.name.dotIdea", this.getName()));
                }
            }
            if ((sdk = ProjectRootManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).getProjectSdk()) == null) {
                sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)JavaSdk.getInstance());
            }
            wizardContext.setProjectJdk(sdk);
            Path dotIdeaFile = wizardContext.getProjectDirectory().resolve(".idea");
            Path projectFile = wizardContext.getProjectDirectory().resolve(wizardContext.getProjectName() + ".ipr").normalize();
            Path pathToOpen = wizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT ? projectFile.toAbsolutePath() : dotIdeaFile.getParent();
            boolean shouldOpenExisting = false;
            boolean importToProject2 = true;
            if (Files.exists(projectFile, new LinkOption[0]) || Files.exists(dotIdeaFile, new LinkOption[0])) {
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    shouldOpenExisting = true;
                    importToProject2 = true;
                } else {
                    String existingName = null;
                    if (Files.exists(dotIdeaFile, new LinkOption[0])) {
                        existingName = "an existing project";
                        pathToOpen = dotIdeaFile.getParent();
                    } else {
                        existingName = "" + '\'' + projectFile.getFileName() + '\'';
                        pathToOpen = projectFile;
                    }
                    int result = Messages.showYesNoCancelDialog((Project)projectToClose, (String)JavaUiBundle.message("project.import.open.existing", existingName, projectFile.getParent(), virtualFile.getName()), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)JavaUiBundle.message("project.import.open.existing.openExisting", new Object[0]), (String)JavaUiBundle.message("project.import.open.existing.reimport", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                    if (result == 2) {
                        Project project = null;
                        return project;
                    }
                    shouldOpenExisting = result == 0;
                    importToProject2 = !shouldOpenExisting;
                }
            }
            Function1 result = null;
            Project project = null;
            Function1 function1 = null;
            boolean bl = false;
            boolean bl2 = false;
            String string = null;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n = 0;
            int n2 = 0;
            FrameInfo frameInfo = null;
            ProjectOpenedCallback projectOpenedCallback = null;
            boolean bl6 = false;
            String string2 = wizardContext.getProjectName();
            Project project2 = null;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = forceOpenInNewFrame;
            Project project3 = projectToClose;
            OpenProjectTask options = new OpenProjectTask(bl9, project3, bl8, bl7, project2, string2, bl6, projectOpenedCallback, frameInfo, n2, n, bl5, bl4, bl3, string, bl2, bl, function1, project, result, 1048540, null);
            if (!shouldOpenExisting) {
                options = OpenProjectTask.copy$default((OpenProjectTask)options, (boolean)false, null, (boolean)true, (boolean)false, null, null, (boolean)false, null, null, (int)0, (int)0, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (boolean)false, null, null, null, (int)1048571, null);
            }
            if (importToProject2) {
                options = OpenProjectTask.copy$default((OpenProjectTask)options, (boolean)false, null, (boolean)false, (boolean)false, null, null, (boolean)false, null, null, (int)0, (int)0, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (boolean)false, null, (Function1)((Function1)new Function1<Project, Boolean>(this, projectToClose, wizardContext){
                    final /* synthetic */ ProjectOpenProcessorBase this$0;
                    final /* synthetic */ Project $projectToClose;
                    final /* synthetic */ WizardContext $wizardContext;

                    public final boolean invoke(@NotNull Project project) {
                        return ProjectOpenProcessorBase.access$importToProject(this.this$0, project, this.$projectToClose, this.$wizardContext);
                    }
                    {
                        this.this$0 = projectOpenProcessorBase;
                        this.$projectToClose = project;
                        this.$wizardContext = wizardContext;
                        super(1);
                    }
                }), null, (int)786431, null);
            }
            try {
                Project project4 = ProjectManagerEx.getInstanceEx().openProject(pathToOpen, options);
                ProjectUtil.updateLastProjectLocation((Path)pathToOpen);
                project = project4;
                return project;
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger.getInstance(ProjectOpenProcessorBase.class).warn((Throwable)e);
                this.getBuilder().cleanup();
            }
        }
        finally {
            this.getBuilder().cleanup();
        }
        return null;
    }

    private final boolean importToProject(Project projectToOpen, Project projectToClose, WizardContext wizardContext) {
        return (Boolean)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Boolean>(this, projectToClose, projectToOpen, wizardContext){
            final /* synthetic */ ProjectOpenProcessorBase this$0;
            final /* synthetic */ Project $projectToClose;
            final /* synthetic */ Project $projectToOpen;
            final /* synthetic */ WizardContext $wizardContext;

            public final boolean invoke() {
                if (!this.this$0.getBuilder().validate(this.$projectToClose, this.$projectToOpen)) {
                    return false;
                }
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ importToProject.1 this$0;

                    public final void run() {
                        block1: {
                            Sdk sdk = this.this$0.$wizardContext.getProjectJdk();
                            if (sdk != null) {
                                Sdk sdk2 = sdk;
                                boolean bl = false;
                                boolean bl2 = false;
                                Sdk it = sdk2;
                                boolean bl3 = false;
                                NewProjectUtil.applyJdkToProject(this.this$0.$projectToOpen, it);
                            }
                            String projectDirPath = this.this$0.$wizardContext.getProjectFileDirectory();
                            String path = projectDirPath + (StringsKt.endsWith$default((CharSequence)projectDirPath, (char)'/', (boolean)false, (int)2, null) ? "classes" : "/classes");
                            CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.this$0.$projectToOpen);
                            if (compilerProjectExtension == null) break block1;
                            CompilerProjectExtension compilerProjectExtension2 = compilerProjectExtension;
                            boolean bl = false;
                            boolean bl4 = false;
                            CompilerProjectExtension it = compilerProjectExtension2;
                            boolean bl5 = false;
                            it.setCompilerOutputUrl(ProjectOpenProcessorBase.Companion.getUrl(path));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                ((ProjectImportBuilder)((Object)this.this$0.getBuilder())).commit(this.$projectToOpen, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
                return true;
            }
            {
                this.this$0 = projectOpenProcessorBase;
                this.$projectToClose = project;
                this.$projectToOpen = project2;
                this.$wizardContext = wizardContext;
                super(0);
            }
        }), (int)1, null);
    }

    @Deprecated(message="Override {@link #doGetBuilder()} and use {@code ProjectImportBuilder.EXTENSIONS_POINT_NAME.findExtensionOrFail(yourClass.class)}.")
    protected ProjectOpenProcessorBase(@NotNull T builder) {
        this.myBuilder = builder;
    }

    protected ProjectOpenProcessorBase() {
        this.myBuilder = null;
    }

    public static final /* synthetic */ boolean access$importToProject(ProjectOpenProcessorBase $this, Project projectToOpen, Project projectToClose, WizardContext wizardContext) {
        return $this.importToProject(projectToOpen, projectToClose, wizardContext);
    }

    @JvmStatic
    protected static final boolean canOpenFile(@NotNull VirtualFile file, @NotNull String[] supported) {
        return Companion.canOpenFile(file, supported);
    }

    @JvmStatic
    @NotNull
    public static final String getUrl(@NotNull String path) {
        return Companion.getUrl(path);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/projectImport/ProjectOpenProcessorBase$Companion;", "", "()V", "canOpenFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "supported", "", "", "(Lcom/intellij/openapi/vfs/VirtualFile;[Ljava/lang/String;)Z", "getUrl", "path", "intellij.java.ui"})
    public static final class Companion {
        @JvmStatic
        protected final boolean canOpenFile(@NotNull VirtualFile file, @NotNull String[] supported) {
            return ArraysKt.contains((Object[])supported, (Object)file.getName());
        }

        @JvmStatic
        @NotNull
        public final String getUrl(@NotNull String path) {
            String resolvedPath = null;
            try {
                resolvedPath = FileUtil.resolveShortWindowsName((String)path);
            }
            catch (IOException ignored) {
                resolvedPath = path;
            }
            return VfsUtilCore.pathToUrl((String)resolvedPath);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

