/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.Place;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleConfigurable
extends ProjectStructureElementConfigurable<Module>
implements Place.Navigator {
    private final Module myModule;
    private final ModuleGrouper myModuleGrouper;
    private final ModulesConfigurator myConfigurator;
    private String myModuleName;
    private final ModuleProjectStructureElement myProjectStructureElement;
    private final StructureConfigurableContext myContext;

    public ModuleConfigurable(ModulesConfigurator modulesConfigurator, @NotNull Module module, Runnable updateTree, ModuleGrouper moduleGrouper) {
        super(true, updateTree);
        this.myModule = module;
        this.myModuleGrouper = moduleGrouper;
        this.myConfigurator = modulesConfigurator;
        this.myModuleName = this.myConfigurator.getModuleModel().getActualName(this.myModule);
        this.myContext = ModuleStructureConfigurable.getInstance(this.myModule.getProject()).getContext();
        this.myProjectStructureElement = new ModuleProjectStructureElement(this.myContext, this.myModule);
    }

    public void setDisplayName(String name2) {
        ModifiableModuleModel modifiableModuleModel = this.myConfigurator.getModuleModel();
        if (StringUtil.isEmpty((String)name2)) {
            return;
        }
        if (Comparing.strEqual((String)name2, (String)this.myModuleName)) {
            return;
        }
        try {
            modifiableModuleModel.renameModule(this.myModule, name2);
        }
        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
            // empty catch block
        }
        this.myConfigurator.moduleRenamed(this.myModule, this.myModuleName, name2);
        this.myModuleName = name2;
        this.myConfigurator.setModified(!Comparing.strEqual((String)this.myModuleName, (String)this.myModule.getName()));
        this.myContext.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
    }

    protected void checkName(@NotNull String name2) throws ConfigurationException {
        super.checkName(name2);
        if (this.myModuleGrouper.getShortenedNameByFullModuleName(name2).isEmpty()) {
            throw new ConfigurationException("Short name of a module cannot be empty");
        }
        List list = this.myModuleGrouper.getGroupPathByModuleName(name2);
        if (list.stream().anyMatch(s -> s.isEmpty())) {
            throw new ConfigurationException("Names of parent groups for a module cannot be empty");
        }
    }

    public ModuleGrouper getModuleGrouper() {
        return this.myModuleGrouper;
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.myProjectStructureElement;
    }

    @NotNull
    public Module getEditableObject() {
        return this.myModule;
    }

    public String getBannerSlogan() {
        return JavaUiBundle.message("project.roots.module.banner.text", this.myModuleName);
    }

    public String getDisplayName() {
        return this.myModuleName;
    }

    public Icon getIcon(boolean open) {
        return this.myModule.isDisposed() ? null : ModuleType.get((Module)this.myModule).getIcon();
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? null : editor.getHelpTopic();
    }

    public JComponent createOptionsPanel() {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? null : editor.getPanel();
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public ModuleEditor getModuleEditor() {
        return this.myConfigurator.getModuleEditor(this.myModule);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        ModuleEditor editor = this.getModuleEditor();
        return editor == null ? ActionCallback.REJECTED : editor.navigateTo(place, requestFocus);
    }

    public void queryPlace(@NotNull Place place) {
        ModuleEditor editor = this.getModuleEditor();
        if (editor != null) {
            editor.queryPlace(place);
        }
    }
}

