/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.FormBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryNameAndLevelPanel {
    private final JTextField myLibraryNameField = new JTextField(25);
    private final JComboBox<LibrariesContainer.LibraryLevel> myLevelComboBox;
    private String myDefaultLibraryName;

    public LibraryNameAndLevelPanel(@NotNull FormBuilder formBuilder, @NotNull String libraryName, @Nullable LibrariesContainer.LibraryLevel level) {
        this(formBuilder, libraryName, Arrays.asList(LibrariesContainer.LibraryLevel.values()), level);
    }

    public LibraryNameAndLevelPanel(@NotNull FormBuilder formBuilder, @NotNull String libraryName, @NotNull List<LibrariesContainer.LibraryLevel> availableLevels, @Nullable LibrariesContainer.LibraryLevel level) {
        formBuilder.addLabeledComponent(JavaUiBundle.message("label.library.name", new Object[0]), (JComponent)this.myLibraryNameField);
        this.myLibraryNameField.setText(libraryName);
        this.myLevelComboBox = new ComboBox();
        if (level != null && !availableLevels.isEmpty()) {
            formBuilder.addLabeledComponent(JavaUiBundle.message("label.library.level", new Object[0]), this.myLevelComboBox);
            HashMap<LibrariesContainer.LibraryLevel, String> levels = new HashMap<LibrariesContainer.LibraryLevel, String>();
            levels.put(LibrariesContainer.LibraryLevel.GLOBAL, JavaUiBundle.message("combobox.item.global.library", new Object[0]));
            levels.put(LibrariesContainer.LibraryLevel.PROJECT, JavaUiBundle.message("combobox.item.project.library", new Object[0]));
            levels.put(LibrariesContainer.LibraryLevel.MODULE, JavaUiBundle.message("combobox.item.module.library", new Object[0]));
            this.myLevelComboBox.setRenderer((ListCellRenderer<LibrariesContainer.LibraryLevel>)SimpleListCellRenderer.create((String)"", levels::get));
            this.myLevelComboBox.setModel((ComboBoxModel<LibrariesContainer.LibraryLevel>)new CollectionComboBoxModel(availableLevels, (Object)level));
        }
    }

    public String getLibraryName() {
        return this.myLibraryNameField.getText();
    }

    public LibrariesContainer.LibraryLevel getLibraryLevel() {
        return (LibrariesContainer.LibraryLevel)((Object)this.myLevelComboBox.getSelectedItem());
    }

    public JTextField getLibraryNameField() {
        return this.myLibraryNameField;
    }

    public JComboBox getLevelComboBox() {
        return this.myLevelComboBox;
    }

    public void setDefaultName(@NotNull String defaultLibraryName) {
        if (this.myDefaultLibraryName != null && this.myDefaultLibraryName.equals(this.getLibraryName())) {
            this.myLibraryNameField.setText(defaultLibraryName);
        }
        this.myDefaultLibraryName = defaultLibraryName;
    }

    public static FormBuilder createFormBuilder() {
        return FormBuilder.createFormBuilder();
    }
}

