/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.navigation.AnonymousElementProvider;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JavaAnonymousClassesProvider
implements AnonymousElementProvider {
    public PsiElement @NotNull [] getAnonymousElements(@NotNull PsiElement parent) {
        if (JavaAnonymousClassesProvider.suite(parent)) {
            if (parent instanceof PsiCompiledElement) {
                parent = parent.getNavigationElement();
            }
            if (JavaAnonymousClassesProvider.suite(parent) && !(parent instanceof PsiCompiledElement)) {
                final ArrayList elements = new ArrayList();
                final PsiElement element = parent;
                element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitAnonymousClass(PsiAnonymousClass aClass) {
                        PsiExpressionList arguments = aClass.getArgumentList();
                        if (arguments != null) {
                            for (PsiExpression expression2 : arguments.getExpressions()) {
                                this.visitExpression(expression2);
                            }
                        }
                        elements.add(aClass);
                    }

                    public void visitClass(PsiClass aClass) {
                        if (aClass == element) {
                            super.visitClass(aClass);
                        }
                    }
                });
                if (!elements.isEmpty()) {
                    return elements.toArray(PsiElement.EMPTY_ARRAY);
                }
            }
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static boolean suite(PsiElement element) {
        return element instanceof PsiClass || element instanceof PsiMethod || element instanceof PsiField || element instanceof PsiClassInitializer;
    }
}

