/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.index;

import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.flavor.FileIndexingFlavorProvider;
import com.intellij.util.indexing.flavor.HashBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KtBuiltInFileIndexingFlavorProvider
implements FileIndexingFlavorProvider<CharSequence> {
    @Nullable
    public CharSequence getFlavor(@NotNull IndexedFile file) {
        VirtualFile vFile = file.getFile();
        VirtualFileSystem fs = vFile.getFileSystem();
        if (!(fs instanceof JarFileSystem)) {
            return null;
        }
        VirtualFile root = VfsUtilCore.getRootFile((VirtualFile)vFile);
        return root.getNameSequence();
    }

    public void buildHash(@NotNull CharSequence seq, @NotNull HashBuilder hashBuilder) {
        hashBuilder.putString(seq);
    }

    public int getVersion() {
        return 0;
    }

    @NotNull
    public String getId() {
        return "KtBuiltInFileIndexingFlavorProvider";
    }
}

