/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ProjectDescriptor {
    private List<ModuleDescriptor> myModules = Collections.emptyList();
    private List<LibraryDescriptor> myLibraries = Collections.emptyList();
    private Set<LibraryDescriptor> myLibrariesSet = Collections.emptySet();

    public List<ModuleDescriptor> getModules() {
        return this.myModules;
    }

    public List<LibraryDescriptor> getLibraries() {
        return this.myLibraries;
    }

    public void setModules(@NotNull List<ModuleDescriptor> modules) {
        this.myModules = modules;
    }

    public void setLibraries(List<LibraryDescriptor> libraries2) {
        this.myLibraries = libraries2;
        this.myLibrariesSet = null;
    }

    public boolean isLibraryChosen(LibraryDescriptor lib) {
        Set<LibraryDescriptor> available = this.myLibrariesSet;
        if (available == null) {
            this.myLibrariesSet = available = new HashSet<LibraryDescriptor>(this.myLibraries);
        }
        return available.contains(lib);
    }

    public JavaSdkVersion getRequiredJdkVersion() {
        if (this.isWithModuleInfo()) {
            return JavaSdkVersion.JDK_1_9;
        }
        return null;
    }

    private boolean isWithModuleInfo() {
        return this.myModules.stream().flatMap(module -> module.getSourceRoots().stream()).anyMatch(sourceRoot -> sourceRoot instanceof JavaModuleSourceRoot && ((JavaModuleSourceRoot)sourceRoot).isWithModuleInfoFile());
    }
}

