/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.TreeViewUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.util.FontUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaProjectViewDirectoryHelper
extends ProjectViewDirectoryHelper {
    public JavaProjectViewDirectoryHelper(Project project) {
        super(project);
    }

    @Nullable
    public String getLocationString(@NotNull PsiDirectory directory, boolean includeUrl, boolean includeRootType) {
        String result = null;
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (ProjectRootsUtil.isSourceRoot((PsiDirectory)directory) && aPackage != null) {
            result = StringUtil.nullize((String)aPackage.getQualifiedName(), (boolean)true);
        }
        String baseString = super.getLocationString(directory, includeUrl, includeRootType);
        if (result == null) {
            return baseString;
        }
        if (baseString == null) {
            return result;
        }
        return result + "," + FontUtil.spaceAndThinSpace() + baseString;
    }

    public boolean isShowFQName(ViewSettings settings, Object parentValue, PsiDirectory value2) {
        PsiPackage aPackage;
        return value2 != null && !(parentValue instanceof Project) && settings.isFlattenPackages() && (aPackage = JavaDirectoryService.getInstance().getPackage(value2)) != null && !aPackage.getQualifiedName().isEmpty();
    }

    public boolean shouldHideProjectConfigurationFilesDirectory() {
        return false;
    }

    @NotNull
    public String getNodeName(ViewSettings settings, Object parentValue, PsiDirectory directory) {
        PsiPackage parentPackage;
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (!ProjectRootsUtil.isSourceRoot((PsiDirectory)directory) && aPackage != null && !aPackage.getQualifiedName().isEmpty() && parentValue instanceof PsiDirectory) {
            parentPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)parentValue);
        } else if (ProjectRootsUtil.isSourceRoot((PsiDirectory)directory) && aPackage != null) {
            aPackage = null;
            parentPackage = null;
        } else {
            parentPackage = null;
        }
        return PackageUtil.getNodeName(settings, aPackage, parentPackage, directory.getName(), this.isShowFQName(settings, parentValue, directory));
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return JavaDirectoryService.getInstance().getPackage(directory) == null;
    }

    public boolean isEmptyMiddleDirectory(PsiDirectory directory, boolean strictlyEmpty, @Nullable PsiFileSystemItemFilter filter) {
        return JavaDirectoryService.getInstance().getPackage(directory) != null && TreeViewUtil.isEmptyMiddlePackage(directory, strictlyEmpty, filter);
    }

    public boolean supportsFlattenPackages() {
        return true;
    }

    public boolean supportsHideEmptyMiddlePackages() {
        return true;
    }

    public boolean canRepresent(Object element, PsiDirectory directory) {
        if (super.canRepresent(element, directory)) {
            return true;
        }
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            return Arrays.asList(packageElement.getPackage().getDirectories()).contains(directory);
        }
        return false;
    }
}

