/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeView;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.datatransfer.DataFlavor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFilePasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || ideView == null) {
            return;
        }
        String fileText = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        String className2 = JavaFilePasteProvider.detectClassName(project, fileText);
        if (className2 == null) {
            return;
        }
        assert (fileText != null);
        PsiDirectory targetDir = ideView.getOrChooseDirectory();
        if (targetDir == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project).withName(JavaBundle.message((String)"paste.class.command.name", (Object[])new Object[]{className2})).run(() -> {
            PsiFile file;
            try {
                file = targetDir.createFile(className2 + ".java");
            }
            catch (IncorrectOperationException e) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document != null) {
                document.setText((CharSequence)fileText);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            }
            if (file instanceof PsiJavaFile) {
                JavaFilePasteProvider.updatePackageStatement((PsiJavaFile)file, targetDir);
            }
            PsiNavigationSupport.getInstance().createNavigatable(project, file.getVirtualFile(), -1).navigate(true);
        });
    }

    private static void updatePackageStatement(PsiJavaFile javaFile, PsiDirectory targetDir) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetDir);
        if (aPackage == null) {
            return;
        }
        PsiPackageStatement oldStatement = javaFile.getPackageStatement();
        Project project = javaFile.getProject();
        if (oldStatement != null && !oldStatement.getPackageName().equals(aPackage.getQualifiedName()) || oldStatement == null && aPackage.getQualifiedName().length() > 0) {
            CommandProcessor.getInstance().executeCommand(project, () -> {
                try {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                    PsiPackageStatement newStatement = factory.createPackageStatement(aPackage.getQualifiedName());
                    if (oldStatement != null) {
                        oldStatement.replace((PsiElement)newStatement);
                    } else {
                        PsiElement addedStatement = javaFile.addAfter((PsiElement)newStatement, null);
                        TextRange textRange = addedStatement.getTextRange();
                        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)javaFile, textRange.getStartOffset(), textRange.getEndOffset() + 1);
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }, JavaBundle.message((String)"command.name.updating.package.statement", (Object[])new Object[0]), null);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || ideView == null || ideView.getDirectories().length == 0) {
            return false;
        }
        return JavaFilePasteProvider.getPastedClasses(project, (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)).length >= 1;
    }

    @Nullable
    static String detectClassName(Project project, String fileText) {
        PsiClass[] classes2 = JavaFilePasteProvider.getPastedClasses(project, fileText);
        if (classes2.length < 1) {
            return null;
        }
        for (PsiClass aClass : classes2) {
            if (!aClass.hasModifierProperty("public")) continue;
            return aClass.getName();
        }
        return classes2[0].getName();
    }

    private static PsiClass @NotNull [] getPastedClasses(@NotNull Project project, @Nullable String pasteText) {
        if (pasteText == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("A.java", (Language)JavaLanguage.INSTANCE, (CharSequence)StringUtil.convertLineSeparators((String)pasteText), false, false);
        PsiUtil.FILE_LANGUAGE_LEVEL_KEY.set((UserDataHolder)psiFile, (Object)LanguageLevel.JDK_15_PREVIEW);
        return psiFile instanceof PsiJavaFile ? ((PsiJavaFile)psiFile).getClasses() : PsiClass.EMPTY_ARRAY;
    }
}

