/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import java.awt.event.ActionListener;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShortenCommandLineModeCombo
extends ComboBox<ShortenCommandLine> {
    private final Project myProject;

    public ShortenCommandLineModeCombo(Project project, JrePathEditor pathEditor, ModuleDescriptionsComboBox component) {
        this(project, pathEditor, (Computable<? extends Module>)((Computable)() -> component.getSelectedModule()), (Consumer<? super ActionListener>)((Consumer)listener -> component.addActionListener(listener)));
    }

    public ShortenCommandLineModeCombo(Project project, final JrePathEditor pathEditor, final Computable<? extends Module> component, Consumer<? super ActionListener> listenerConsumer) {
        this.myProject = project;
        this.initModel(null, pathEditor, (Module)component.compute());
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<ShortenCommandLine>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ShortenCommandLine> list, ShortenCommandLine value2, int index, boolean selected, boolean hasFocus) {
                if (value2 == null) {
                    ShortenCommandLine defaultMode = ShortenCommandLine.getDefaultMethod((Project)ShortenCommandLineModeCombo.this.myProject, (String)ShortenCommandLineModeCombo.this.getJdkRoot(pathEditor, (Module)component.compute()));
                    this.append("user-local default: " + defaultMode.getPresentableName()).append(" - " + defaultMode.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    this.append(value2.getPresentableName()).append(" - " + value2.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        });
        ActionListener updateModelListener = e -> {
            ShortenCommandLine item = this.getSelectedItem();
            this.initModel(item, pathEditor, (Module)component.compute());
        };
        pathEditor.addActionListener(updateModelListener);
        listenerConsumer.consume((Object)updateModelListener);
    }

    private void initModel(ShortenCommandLine preselection, JrePathEditor pathEditor, Module module) {
        this.removeAllItems();
        String jdkRoot = this.getJdkRoot(pathEditor, module);
        this.addItem(null);
        for (ShortenCommandLine mode : ShortenCommandLine.values()) {
            if (!mode.isApplicable(jdkRoot)) continue;
            this.addItem(mode);
        }
        this.setSelectedItem(preselection);
    }

    @Nullable
    private String getJdkRoot(JrePathEditor pathEditor, Module module) {
        if (!pathEditor.isAlternativeJreSelected() && module != null) {
            Sdk sdk = JavaParameters.getJdkToRunModule((Module)module, (boolean)this.productionOnly());
            return sdk != null ? sdk.getHomePath() : null;
        }
        String jrePathOrName = pathEditor.getJrePathOrName();
        if (jrePathOrName != null) {
            Sdk configuredJdk = ProjectJdkTable.getInstance().findJdk(jrePathOrName);
            if (configuredJdk != null) {
                return configuredJdk.getHomePath();
            }
            return jrePathOrName;
        }
        return null;
    }

    protected boolean productionOnly() {
        return true;
    }

    @Nullable
    public ShortenCommandLine getSelectedItem() {
        return (ShortenCommandLine)super.getSelectedItem();
    }
}

