/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.ui.BeforeRunComponent;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ModuleClasspathCombo;
import com.intellij.execution.ui.RunConfigurationEditorFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class CommonJavaFragments {
    public static <S extends RunConfigurationBase<?>> SettingsEditorFragment<S, JLabel> createBuildBeforeRun(final BeforeRunComponent beforeRunComponent) {
        final String buildAndRun = ExecutionBundle.message((String)"application.configuration.title.build.and.run", (Object[])new Object[0]);
        final String run2 = ExecutionBundle.message((String)"application.configuration.title.run", (Object[])new Object[0]);
        final JLabel jLabel = new JLabel(buildAndRun);
        jLabel.setFont(JBUI.Fonts.label().deriveFont(1));
        RunConfigurationEditorFragment fragment = new RunConfigurationEditorFragment<S, JLabel>("doNotBuildBeforeRun", ExecutionBundle.message((String)"do.not.build.before.run", (Object[])new Object[0]), ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), jLabel, -1){

            public void resetEditorFrom(@NotNull RunnerAndConfigurationSettingsImpl s) {
                jLabel.setText(this.hasTask(s) ? buildAndRun : run2);
            }

            private boolean hasTask(@NotNull RunnerAndConfigurationSettingsImpl s) {
                return ContainerUtil.exists((Iterable)s.getManager().getBeforeRunTasks(s.getConfiguration()), t -> CompileStepBeforeRun.ID == t.getProviderId());
            }

            public void applyEditorTo(@NotNull RunnerAndConfigurationSettingsImpl s) {
                ArrayList<BeforeRunTask> tasks = new ArrayList<BeforeRunTask>(s.getManager().getBeforeRunTasks(s.getConfiguration()));
                if (!this.isSelected()) {
                    if (!this.hasTask(s)) {
                        CompileStepBeforeRun.MakeBeforeRunTask task = new CompileStepBeforeRun.MakeBeforeRunTask();
                        task.setEnabled(true);
                        tasks.add(task);
                    }
                } else {
                    tasks.removeIf(t -> CompileStepBeforeRun.ID == t.getProviderId());
                }
                s.getManager().setBeforeRunTasks(s.getConfiguration(), tasks);
            }

            public void setSelected(boolean selected) {
                jLabel.setText(selected ? run2 : buildAndRun);
                beforeRunComponent.addOrRemove(CompileStepBeforeRun.ID, !selected);
                this.fireEditorStateChanged();
            }

            public boolean isSelected() {
                return run2.equals(jLabel.getText());
            }

            @NotNull
            protected JComponent createEditor() {
                return this.myComponent;
            }
        };
        beforeRunComponent.setTagListener((key2, added) -> {
            if (CompileStepBeforeRun.ID == key2) {
                jLabel.setText(added != false ? buildAndRun : run2);
            }
        });
        return fragment;
    }

    public static <S extends ModuleBasedConfiguration<?, ?>> SettingsEditorFragment<S, ModuleClasspathCombo> moduleClasspath(ModuleClasspathCombo.Item option, Predicate<S> getter, BiConsumer<S, Boolean> setter) {
        ModuleClasspathCombo comboBox = new ModuleClasspathCombo(option);
        String name2 = ExecutionBundle.message((String)"application.configuration.use.classpath.and.jdk.of.module", (Object[])new Object[0]);
        comboBox.getAccessibleContext().setAccessibleName(name2);
        CommandLinePanel.setMinimumWidth((Component)comboBox, (int)400);
        UIUtil.setMonospaced((Component)comboBox);
        SettingsEditorFragment fragment = new SettingsEditorFragment("module.classpath", name2, ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), (JComponent)comboBox, 10, (s, c) -> {
            comboBox.reset((ModuleBasedConfiguration)s);
            option.myOptionValue = getter.test(s);
        }, (s, c) -> {
            if (comboBox.isVisible()) {
                comboBox.applyTo((ModuleBasedConfiguration)s);
                setter.accept(s, option.myOptionValue);
            } else {
                s.setModule(s.getDefaultModule());
                setter.accept(s, false);
            }
        }, s -> s.getDefaultModule() != s.getConfigurationModule().getModule());
        fragment.setHint(ExecutionBundle.message((String)"application.configuration.use.classpath.and.jdk.of.module.hint", (Object[])new Object[0]));
        return fragment;
    }

    @NotNull
    public static SettingsEditorFragment<ApplicationConfiguration, JrePathEditor> createJrePath(Project project) {
        JrePathEditor jrePathEditor = new JrePathEditor(false);
        ComboBox comboBox = (ComboBox)jrePathEditor.getComponent();
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JrePathEditor.JreComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JrePathEditor.JreComboBoxItem> list, JrePathEditor.JreComboBoxItem value2, int index, boolean selected, boolean hasFocus) {
                if (value2 != null) {
                    if (index == -1) {
                        this.append("java ");
                        this.append("(" + value2.getPresentableText() + ")");
                    } else {
                        value2.render((SimpleColoredComponent)this, selected);
                    }
                }
            }
        });
        UIUtil.setMonospaced((Component)comboBox);
        CommandLinePanel.setMinimumWidth((Component)((Object)jrePathEditor), (int)100);
        jrePathEditor.getLabel().setVisible(false);
        ((ComboBox)jrePathEditor.getComponent()).getAccessibleContext().setAccessibleName(jrePathEditor.getLabel().getText());
        jrePathEditor.setDefaultJreSelector(DefaultJreSelector.projectSdk(project));
        return new SettingsEditorFragment("jrePath", null, null, (JComponent)((Object)jrePathEditor), 5, (configuration, editor) -> editor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled()), (configuration, editor) -> {
            configuration.setAlternativeJrePath(editor.getJrePathOrName());
            configuration.setAlternativeJrePathEnabled(editor.isAlternativeJreSelected());
        }, configuration -> true);
    }
}

