/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LocalTestDiscoveryProducer
implements TestDiscoveryProducer {
    @Override
    @NotNull
    public MultiMap<String, String> getDiscoveredTests(@NotNull Project project, @NotNull List<? extends Couple<String>> classesAndMethods, byte frameworkId) {
        MultiMap result = new MultiMap();
        TestDiscoveryIndex instance = TestDiscoveryIndex.getInstance(project);
        classesAndMethods.forEach(couple -> result.putAllValues(couple.second == null ? instance.getTestsByClassName((String)couple.first, frameworkId) : instance.getTestsByMethodName((String)couple.first, (String)couple.second, frameworkId)));
        return result;
    }

    @Override
    @NotNull
    public MultiMap<String, String> getDiscoveredTestsForFiles(@NotNull Project project, @NotNull List<String> paths, byte frameworkId) {
        MultiMap result = new MultiMap();
        TestDiscoveryIndex instance = TestDiscoveryIndex.getInstance(project);
        for (String path : paths) {
            result.putAllValues(instance.getTestsByFile(path, frameworkId));
        }
        return result;
    }

    @Override
    @NotNull
    public List<String> getAffectedFilePaths(@NotNull Project project, @NotNull List<? extends Couple<String>> testFqns, byte frameworkId) {
        TestDiscoveryIndex instance = TestDiscoveryIndex.getInstance(project);
        HashSet<String> result = new HashSet<String>();
        for (Couple<String> couple : testFqns) {
            result.addAll(instance.getAffectedFiles(couple, frameworkId));
        }
        return new ArrayList<String>(result);
    }

    @Override
    @NotNull
    public List<String> getAffectedFilePathsByClassName(@NotNull Project project, @NotNull String testClassName, byte frameworkId) {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<String> getFilesWithoutTests(@NotNull Project project, @NotNull Collection<String> paths) {
        return Collections.emptyList();
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

