/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testframework.autotest.AbstractAutoTestManager;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;

@State(name="JavaAutoRunManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class JavaAutoRunManager
extends AbstractAutoTestManager {
    @NotNull
    public static JavaAutoRunManager getInstance(Project project) {
        return (JavaAutoRunManager)((Object)ServiceManager.getService((Project)project, JavaAutoRunManager.class));
    }

    public JavaAutoRunManager(@NotNull Project project) {
        super(project);
    }

    @NotNull
    protected AutoTestWatcher createWatcher(final @NotNull Project project) {
        return new AutoTestWatcher(){
            private boolean myHasErrors = false;
            private Disposable myEventDisposable;

            public void activate() {
                if (this.myEventDisposable != null) {
                    return;
                }
                this.myEventDisposable = Disposer.newDisposable();
                Disposer.register((Disposable)project, (Disposable)this.myEventDisposable);
                project.getMessageBus().connect(this.myEventDisposable).subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){
                    private boolean myFoundFilesToMake = false;

                    public void compilationFinished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                        if (!this.myFoundFilesToMake) {
                            return;
                        }
                        if (errors == 0) {
                            JavaAutoRunManager.this.restartAllAutoTests(0);
                        }
                        myHasErrors = errors == 0;
                        this.myFoundFilesToMake = false;
                    }

                    public void automakeCompilationFinished(int errors, int warnings, @NotNull CompileContext compileContext) {
                        this.compilationFinished(false, errors, warnings, compileContext);
                    }

                    public void fileGenerated(@NotNull String outputRoot, @NotNull String relativePath) {
                        this.myFoundFilesToMake = true;
                    }
                });
            }

            public void deactivate() {
                Disposable eventDisposable = this.myEventDisposable;
                if (eventDisposable != null) {
                    this.myEventDisposable = null;
                    Disposer.dispose((Disposable)eventDisposable);
                }
            }

            public boolean isUpToDate(int modificationStamp) {
                return !this.myHasErrors;
            }
        };
    }
}

