/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.scratch.JavaScratchCompilationSupport;
import com.intellij.execution.scratch.JavaScratchConfigurable;
import com.intellij.execution.scratch.JavaScratchConfigurationOptions;
import com.intellij.execution.scratch.JavaScratchPositionManager;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScratchConfiguration
extends ApplicationConfiguration {
    protected JavaScratchConfiguration(String name2, @NotNull Project project, @NotNull ConfigurationFactory factory) {
        super(name2, project, factory);
    }

    public boolean isBuildProjectOnEmptyModuleList() {
        return false;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE(this);
        String className2 = this.getMainClassName();
        if (className2 == null || className2.length() == 0) {
            throw new RuntimeConfigurationError(ExecutionBundle.message((String)"no.main.class.specified.error.text", (Object[])new Object[0]));
        }
        if (this.getScratchFileUrl() == null) {
            throw new RuntimeConfigurationError("No scratch file associated with configuration");
        }
        if (this.getScratchVirtualFile() == null) {
            throw new RuntimeConfigurationError("Associated scratch file not found");
        }
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)((JavaRunConfigurationModule)this.getConfigurationModule()).getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid(this);
    }

    @Override
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration> state = new ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration>(this, env){

            @Override
            protected JavaParameters createJavaParameters() throws ExecutionException {
                ParametersList vmOptions;
                JavaSdkVersion version;
                JavaParameters params = super.createJavaParameters();
                Sdk jdk = params.getJdk();
                if (jdk != null && (version = JavaSdk.getInstance().getVersion(jdk)) != null && version.getMaxLanguageLevel().isPreview() && !(vmOptions = params.getVMParametersList()).hasParameter("--enable-preview")) {
                    vmOptions.add("--enable-preview");
                }
                return params;
            }

            @Override
            protected void setupJavaParameters(@NotNull JavaParameters params) throws ExecutionException {
                super.setupJavaParameters(params);
                File scrachesOutput = JavaScratchCompilationSupport.getScratchOutputDirectory(JavaScratchConfiguration.this.getProject());
                if (scrachesOutput != null) {
                    params.getClassPath().addFirst(FileUtil.toCanonicalPath((String)scrachesOutput.getAbsolutePath()).replace('/', File.separatorChar));
                }
            }

            @Override
            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                VirtualFile vFile;
                OSProcessHandler handler = super.startProcess();
                if (this.getRunnerSettings() instanceof DebuggingRunnerData && (vFile = ((JavaScratchConfiguration)this.getConfiguration()).getScratchVirtualFile()) != null) {
                    DebuggerManager.getInstance((Project)JavaScratchConfiguration.this.getProject()).addDebugProcessListener((ProcessHandler)handler, new DebugProcessListener(){

                        public void processAttached(@NotNull DebugProcess process2) {
                            if (vFile.isValid()) {
                                process2.appendPositionManager((PositionManager)new JavaScratchPositionManager((DebugProcessImpl)process2, vFile));
                            }
                            process2.removeDebugProcessListener((DebugProcessListener)this);
                        }
                    });
                }
                return handler;
            }
        };
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), ((JavaRunConfigurationModule)this.getConfigurationModule()).getSearchScope()));
        return state;
    }

    @Override
    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new JavaScratchConfigurable(this.getProject());
    }

    public void setScratchFileUrl(String url) {
        this.getOptions().setScratchFileUrl(url);
    }

    @Nullable
    public String getScratchFileUrl() {
        return this.getOptions().getScratchFileUrl();
    }

    @Nullable
    public VirtualFile getScratchVirtualFile() {
        String url = this.getScratchFileUrl();
        return url == null ? null : VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Override
    @NotNull
    protected JavaScratchConfigurationOptions getOptions() {
        return (JavaScratchConfigurationOptions)super.getOptions();
    }
}

