/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExcludeFromRunAction<T extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>>
extends AnAction {
    private static final Logger LOG = Logger.getInstance(AbstractExcludeFromRunAction.class);

    protected abstract Set<String> getPattern(T var1);

    protected abstract boolean isPatternBasedConfiguration(RunConfiguration var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        LOG.assertTrue(project != null);
        ModuleBasedConfiguration configuration = (ModuleBasedConfiguration)RunConfiguration.DATA_KEY.getData(dataContext);
        LOG.assertTrue(configuration != null);
        GlobalSearchScope searchScope = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getSearchScope();
        AbstractTestProxy testProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(dataContext);
        LOG.assertTrue(testProxy != null);
        String qualifiedName = ((PsiClass)testProxy.getLocation(project, searchScope).getPsiElement()).getQualifiedName();
        this.getPattern(configuration).remove(qualifiedName);
    }

    public void update(@NotNull AnActionEvent e) {
        PsiElement psiElement;
        Location location;
        AbstractTestProxy testProxy;
        RunConfiguration configuration;
        Presentation presentation = e.getPresentation();
        presentation.setVisible(false);
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && this.isPatternBasedConfiguration(configuration = (RunConfiguration)RunConfiguration.DATA_KEY.getData(dataContext)) && (testProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(dataContext)) != null && (location = testProxy.getLocation(project, ((JavaRunConfigurationModule)((ModuleBasedConfiguration)configuration).getConfigurationModule()).getSearchScope())) != null && (psiElement = location.getPsiElement()) instanceof PsiClass && this.getPattern((ModuleBasedConfiguration)configuration).contains(((PsiClass)psiElement).getQualifiedName())) {
            presentation.setVisible(true);
        }
    }
}

