/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.Location;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.java.JavaLanguageRuntimeType;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaTestConfigurationBase
extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>
implements CommonJavaRunConfigurationParameters,
ConfigurationWithCommandLineShortener,
RefactoringListenerProvider,
SMRunnerConsolePropertiesProvider,
TargetEnvironmentAwareRunProfile {
    private ShortenCommandLine myShortenCommandLine = null;
    private boolean myUseModulePath = true;
    private static final String USE_CLASS_PATH_ONLY = "useClassPathOnly";

    public JavaTestConfigurationBase(String name2, @NotNull JavaRunConfigurationModule configurationModule, @NotNull ConfigurationFactory factory) {
        super(name2, (RunConfigurationModule)configurationModule, factory);
    }

    public JavaTestConfigurationBase(@NotNull JavaRunConfigurationModule configurationModule, @NotNull ConfigurationFactory factory) {
        super((RunConfigurationModule)configurationModule, factory);
    }

    public abstract void bePatternConfiguration(List<PsiClass> var1, PsiMethod var2);

    public abstract void beMethodConfiguration(Location<PsiMethod> var1);

    public abstract void beClassConfiguration(PsiClass var1);

    public abstract boolean isConfiguredByElement(PsiElement var1);

    public abstract String getTestType();

    public String prepareParameterizedParameter(String paramSetName) {
        return paramSetName;
    }

    public abstract TestSearchScope getTestSearchScope();

    public abstract void setSearchScope(TestSearchScope var1);

    @Nullable
    public abstract JavaTestFrameworkRunnableState<? extends JavaTestConfigurationBase> getState(@NotNull Executor var1, @NotNull ExecutionEnvironment var2) throws ExecutionException;

    @Nullable
    public ShortenCommandLine getShortenCommandLine() {
        return this.myShortenCommandLine;
    }

    public void setShortenCommandLine(@Nullable ShortenCommandLine shortenCommandLine) {
        this.myShortenCommandLine = shortenCommandLine;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        super.readExternal(element);
        this.setShortenCommandLine(ShortenCommandLine.readShortenClasspathMethod((Element)element));
        this.myUseModulePath = element.getChild(USE_CLASS_PATH_ONLY) == null;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        super.writeExternal(element);
        ShortenCommandLine.writeShortenClasspathMethod((Element)element, (ShortenCommandLine)this.myShortenCommandLine);
        if (!this.myUseModulePath) {
            element.addContent(new Element(USE_CLASS_PATH_ONLY));
        }
    }

    public boolean isUseModulePath() {
        return this.myUseModulePath;
    }

    public void setUseModulePath(boolean useModulePath) {
        this.myUseModulePath = useModulePath;
    }

    public boolean canRunOn(@NotNull TargetEnvironmentConfiguration target) {
        return target.getRuntimes().findByType(JavaLanguageRuntimeConfiguration.class) != null;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return (LanguageRuntimeType)LanguageRuntimeType.EXTENSION_NAME.findExtension(JavaLanguageRuntimeType.class);
    }

    @Nullable
    public String getDefaultTargetName() {
        return this.getOptions().getRemoteTarget();
    }

    public void setDefaultTargetName(@Nullable String targetName) {
        this.getOptions().setRemoteTarget(targetName);
    }
}

