/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import com.intellij.designer.PaletteToolWindowContent;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.palette.PaletteContainer;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteGroupComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.palette.PaletteItemsComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PalettePanel
extends JPanel
implements DataProvider,
PaletteToolWindowContent {
    private final JPanel myPaletteContainer = new PaletteContainer();
    private List<PaletteGroupComponent> myGroupComponents = Collections.emptyList();
    private List<PaletteItemsComponent> myItemsComponents = Collections.emptyList();
    private List<PaletteGroup> myGroups = Collections.emptyList();
    private DesignerEditorPanel myDesigner;
    private final FocusListener myFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            for (PaletteItemsComponent itemsComponent : PalettePanel.this.myItemsComponents) {
                itemsComponent.clearSelection();
            }
        }
    };
    private final ListSelectionListener mySelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent event) {
            PalettePanel.this.notifySelection(event);
        }
    };
    private final DragSourceListener myDragSourceListener = new DragSourceAdapter(){

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            Component component = event.getDragSourceContext().getComponent();
            if (!event.getDropSuccess() && component instanceof PaletteItemsComponent && PalettePanel.this.myDesigner != null && PalettePanel.this.myDesigner.getRootPane() == ((JComponent)component).getRootPane()) {
                PalettePanel.this.myDesigner.getToolProvider().loadDefaultTool();
            }
        }
    };

    public PalettePanel() {
        super(new GridLayout(1, 1));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myPaletteContainer);
        scrollPane.setBorder(null);
        this.add(scrollPane);
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                PalettePanel.this.clearActiveItem();
            }
        }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)scrollPane);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().addDragSourceListener(this.myDragSourceListener);
        }
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().removeDragSourceListener(this.myDragSourceListener);
        }
    }

    @Nullable
    public PaletteItem getActiveItem() {
        for (PaletteGroupComponent groupComponent : this.myGroupComponents) {
            PaletteItem paletteItem;
            if (!groupComponent.isSelected() || (paletteItem = (PaletteItem)groupComponent.getItemsComponent().getSelectedValue()) == null) continue;
            return paletteItem;
        }
        return null;
    }

    @Override
    public void clearActiveItem() {
        if (this.getActiveItem() != null) {
            for (PaletteItemsComponent itemsComponent : this.myItemsComponents) {
                itemsComponent.clearSelection();
            }
            this.notifySelection(null);
        }
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    public void loadPalette(@Nullable DesignerEditorPanel designer) {
        if (this.myDesigner == null && designer == null) {
            return;
        }
        if (this.myDesigner != null && designer != null && this.myGroups.equals(designer.getPaletteGroups())) {
            this.myDesigner = designer;
            this.restoreSelection();
            return;
        }
        for (PaletteItemsComponent itemsComponent : this.myItemsComponents) {
            itemsComponent.removeListSelectionListener(this.mySelectionListener);
        }
        this.myDesigner = designer;
        this.myPaletteContainer.removeAll();
        if (designer == null) {
            this.myGroups = Collections.emptyList();
            this.myGroupComponents = Collections.emptyList();
            this.myItemsComponents = Collections.emptyList();
        } else {
            this.myGroups = designer.getPaletteGroups();
            this.myGroupComponents = new ArrayList<PaletteGroupComponent>();
            this.myItemsComponents = new ArrayList<PaletteItemsComponent>();
        }
        for (PaletteGroup group : this.myGroups) {
            PaletteGroupComponent groupComponent = new PaletteGroupComponent(group);
            PaletteItemsComponent itemsComponent = new PaletteItemsComponent(group, designer);
            groupComponent.setItemsComponent(itemsComponent);
            groupComponent.addFocusListener(this.myFocusListener);
            this.myGroupComponents.add(groupComponent);
            itemsComponent.addListSelectionListener(this.mySelectionListener);
            this.myItemsComponents.add(itemsComponent);
            this.myPaletteContainer.add(groupComponent);
            this.myPaletteContainer.add((Component)((Object)itemsComponent));
        }
        this.myPaletteContainer.revalidate();
        if (this.myDesigner != null) {
            this.restoreSelection();
        }
    }

    private void restoreSelection() {
        PaletteItem paletteItem = this.myDesigner.getActivePaletteItem();
        for (PaletteItemsComponent itemsComponent : this.myItemsComponents) {
            itemsComponent.restoreSelection(paletteItem);
        }
    }

    private void notifySelection(@Nullable ListSelectionEvent event) {
        if (event != null) {
            PaletteItemsComponent sourceItemsComponent = (PaletteItemsComponent)((Object)event.getSource());
            for (int i = event.getFirstIndex(); i <= event.getLastIndex(); ++i) {
                if (!sourceItemsComponent.isSelectedIndex(i)) continue;
                for (PaletteItemsComponent itemsComponent : this.myItemsComponents) {
                    if (itemsComponent == sourceItemsComponent) continue;
                    itemsComponent.clearSelection();
                }
                PaletteItem paletteItem = (PaletteItem)sourceItemsComponent.getSelectedValue();
                if (paletteItem == null || paletteItem.isEnabled()) break;
                sourceItemsComponent.clearSelection();
                break;
            }
        }
        if (this.myDesigner != null) {
            this.myDesigner.activatePaletteItem(this.getActiveItem());
        }
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (PlatformDataKeys.FILE_EDITOR.is(dataId) && this.myDesigner != null) {
            return this.myDesigner.getEditor();
        }
        return null;
    }
}

