/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.feedbacks;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class AlphaFeedback
extends JComponent {
    protected static final AlphaComposite myComposite1 = AlphaComposite.getInstance(10, 0.3f);
    protected static final AlphaComposite myComposite2 = AlphaComposite.getInstance(10, 0.6f);
    private final Color myColor;
    private final Color myBorderColor;

    public AlphaFeedback(Color color) {
        this(color, color);
    }

    public AlphaFeedback(Color color, Color borderColor) {
        this.myColor = color;
        this.myBorderColor = borderColor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.myColor);
        g2d.setComposite(myComposite1);
        this.paintOther1(g2d);
        g2d.setColor(this.myBorderColor);
        g2d.setComposite(myComposite2);
        this.paintOther2(g2d);
    }

    protected void paintOther1(Graphics2D g2d) {
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected void paintOther2(Graphics2D g2d) {
        g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public static void fillRect1(Graphics g, int x, int y, int width, int height, Color color) {
        AlphaFeedback.fillRect(g, x, y, width, height, color, myComposite1);
    }

    public static void fillRect2(Graphics g, int x, int y, int width, int height, Color color) {
        AlphaFeedback.fillRect(g, x, y, width, height, color, myComposite2);
    }

    public static void fillRect(Graphics g, int x, int y, int width, int height, Color color, Composite composite) {
        Graphics2D g2d = (Graphics2D)g;
        Composite oldComposite = g2d.getComposite();
        Color oldColor = g.getColor();
        g2d.setColor(color);
        g2d.setComposite(composite);
        g2d.fillRect(x, y, width, height);
        g2d.setComposite(oldComposite);
        g2d.setColor(oldColor);
    }
}

