/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.actions.DesignerActionPanel;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.FeedbackTreeLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ArrayUtilRt;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeEditableArea
implements EditableArea,
FeedbackTreeLayer,
TreeSelectionListener {
    private final EventListenerList myListenerList = new EventListenerList();
    private final ComponentTree myTree;
    private final AbstractTreeBuilder myTreeBuilder;
    private final DesignerActionPanel myActionPanel;
    private boolean myCanvasSelection;

    public TreeEditableArea(ComponentTree tree, AbstractTreeBuilder treeBuilder, DesignerActionPanel actionPanel) {
        this.myTree = tree;
        this.myTreeBuilder = treeBuilder;
        this.myActionPanel = actionPanel;
        this.hookSelection();
    }

    private void hookSelection() {
        this.myTree.getSelectionModel().addTreeSelectionListener(this);
    }

    public void unhookSelection() {
        this.myTree.getSelectionModel().removeTreeSelectionListener(this);
    }

    @Override
    public void addSelectionListener(ComponentSelectionListener listener) {
        this.myListenerList.add(ComponentSelectionListener.class, listener);
    }

    @Override
    public void removeSelectionListener(ComponentSelectionListener listener) {
        this.myListenerList.remove(ComponentSelectionListener.class, listener);
    }

    private void fireSelectionChanged() {
        for (ComponentSelectionListener listener : (ComponentSelectionListener[])this.myListenerList.getListeners(ComponentSelectionListener.class)) {
            listener.selectionChanged(this);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.myTreeBuilder.isSelectionBeingAdjusted() && ApplicationManager.getApplication().isDispatchThread()) {
            this.fireSelectionChanged();
        }
    }

    @Override
    @NotNull
    public List<RadComponent> getSelection() {
        return new ArrayList<RadComponent>(this.getRawSelection());
    }

    @Override
    public boolean isSelected(@NotNull RadComponent component) {
        return this.getRawSelection().contains((Object)component);
    }

    @Override
    public void select(@NotNull RadComponent component) {
        this.setRawSelection((Object)component);
    }

    @Override
    public void deselect(@NotNull RadComponent component) {
        Collection<RadComponent> selection = this.getRawSelection();
        selection.remove((Object)component);
        this.setRawSelection(selection);
    }

    @Override
    public void appendSelection(@NotNull RadComponent component) {
        Collection<RadComponent> selection = this.getRawSelection();
        selection.add(component);
        this.setRawSelection(selection);
    }

    @Override
    public void setSelection(@NotNull List<RadComponent> components) {
        this.setRawSelection(components);
    }

    @Override
    public void deselect(@NotNull Collection<RadComponent> components) {
        Collection<RadComponent> selection = this.getRawSelection();
        selection.removeAll(components);
        this.setRawSelection(selection);
    }

    @Override
    public void deselectAll() {
        this.setRawSelection(null);
    }

    @Override
    public void scrollToSelection() {
    }

    private Collection<RadComponent> getRawSelection() {
        return this.myTreeBuilder.getSelectedElements(RadComponent.class);
    }

    private void setRawSelection(@Nullable Object value2) {
        this.unhookSelection();
        this.myTreeBuilder.queueUpdate();
        if (value2 == null) {
            this.myTreeBuilder.select(ArrayUtilRt.EMPTY_OBJECT_ARRAY, null);
            this.myTree.clearSelection();
        } else if (value2 instanceof RadComponent) {
            this.myTreeBuilder.select(value2);
        } else {
            Collection collection = (Collection)value2;
            this.myTreeBuilder.select(collection.toArray(), null);
            if (collection.isEmpty()) {
                this.myTree.clearSelection();
            }
        }
        this.myTreeBuilder.queueUpdate();
        this.hookSelection();
        this.fireSelectionChanged();
    }

    public boolean isCanvasSelection() {
        return this.myCanvasSelection;
    }

    public void setCanvasSelection(boolean canvasSelection) {
        this.myCanvasSelection = canvasSelection;
    }

    @Override
    public void setCursor(@Nullable Cursor cursor) {
        this.myTree.setCursor(cursor);
    }

    @Override
    public void setDescription(@Nullable String text2) {
    }

    @Override
    @NotNull
    public JComponent getNativeComponent() {
        return this.myTree;
    }

    @Override
    public RadComponent findTarget(int x, int y, @Nullable ComponentTargetFilter filter) {
        TreePath path = this.myTree.getPathForLocation(x, y);
        if (path != null) {
            RadComponent component;
            if (filter != null) {
                for (component = this.myTree.extractComponent(path.getLastPathComponent()); !(component == null || filter.preFilter(component) && filter.resultFilter(component)); component = component.getParent()) {
                }
            }
            return component;
        }
        return null;
    }

    @Override
    public InputTool findTargetTool(int x, int y) {
        return null;
    }

    @Override
    public void showSelection(boolean value2) {
    }

    @Override
    public ComponentDecorator getRootSelectionDecorator() {
        return null;
    }

    @Override
    public EditOperation processRootOperation(OperationContext context) {
        return null;
    }

    @Override
    public FeedbackLayer getFeedbackLayer() {
        return null;
    }

    @Override
    public RadComponent getRootComponent() {
        return null;
    }

    @Override
    public boolean isTree() {
        return true;
    }

    @Override
    public FeedbackTreeLayer getFeedbackTreeLayer() {
        return this;
    }

    @Override
    public ActionGroup getPopupActions() {
        return this.myActionPanel.getPopupActions(this);
    }

    @Override
    public String getPopupPlace() {
        return "GuiDesigner.ComponentTreePopup";
    }

    private TreePath getPath(@NotNull RadComponent component) {
        DefaultMutableTreeNode node = this.myTreeBuilder.getNodeForElement((Object)component);
        return node == null ? null : new TreePath(node.getPath());
    }

    @Override
    public void mark(RadComponent component, int feedback) {
        if (component != null) {
            TreePath path = this.getPath(component);
            if (feedback == 2) {
                this.myTree.scrollPathToVisible(path);
                if (!this.myTree.isExpanded(path)) {
                    this.myTreeBuilder.expand((Object)component, null);
                }
            } else {
                this.myTree.scrollRowToVisible(this.myTree.getRowForPath(path) + (feedback == 0 ? -1 : 1));
            }
        }
        this.myTree.mark(component, feedback);
    }

    @Override
    public void unmark() {
        this.myTree.mark(null, -1);
    }

    @Override
    public boolean isBeforeLocation(@NotNull RadComponent component, int x, int y) {
        Rectangle bounds = this.myTree.getPathBounds(this.getPath(component));
        return bounds != null && y - bounds.y < this.myTree.getEdgeSize();
    }

    @Override
    public boolean isAfterLocation(@NotNull RadComponent component, int x, int y) {
        Rectangle bounds = this.myTree.getPathBounds(this.getPath(component));
        return bounds != null && bounds.getMaxY() - (double)y < (double)this.myTree.getEdgeSize();
    }
}

