/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SelectSiblingsAction
extends AnAction {
    private final EditableArea myArea;

    public SelectSiblingsAction(EditableArea area) {
        super("Select Siblings", "Select Siblings", null);
        this.myArea = area;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        RadComponent rootComponent = this.myArea.getRootComponent();
        if (rootComponent != null) {
            final Set<RadComponent> parents = RadComponent.getParents(this.myArea.getSelection());
            final ArrayList<RadComponent> components = new ArrayList<RadComponent>();
            rootComponent.accept(new RadComponentVisitor(){

                @Override
                public void endVisit(RadComponent component) {
                    if (parents.contains((Object)component.getParent())) {
                        components.add(component);
                    }
                }
            }, true);
            this.myArea.setSelection(components);
        }
    }
}

