/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.ui.tree.render.BasicRendererProperties;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.sun.jdi.Type;
import java.util.concurrent.CompletableFuture;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class ReferenceRenderer
implements Renderer {
    private static final Logger LOG = Logger.getInstance(ReferenceRenderer.class);
    protected BasicRendererProperties myProperties = new BasicRendererProperties(false);

    protected ReferenceRenderer() {
        this("java.lang.Object");
    }

    protected ReferenceRenderer(@NotNull String className2) {
        this.myProperties.setClassName(className2);
    }

    @Override
    public CompletableFuture<Boolean> isApplicableAsync(Type type2) {
        return DebuggerUtilsAsync.instanceOf(type2, this.getClassName());
    }

    public String getClassName() {
        return this.myProperties.getClassName();
    }

    public void setClassName(String className2) {
        this.myProperties.setClassName(className2);
    }

    @Override
    public Renderer clone() {
        try {
            ReferenceRenderer cloned = (ReferenceRenderer)super.clone();
            cloned.myProperties = this.myProperties.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myProperties.writeExternal(element, "java.lang.Object");
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myProperties.readExternal(element, "java.lang.Object");
    }

    protected CachedEvaluator createCachedEvaluator() {
        return new CachedEvaluator(){

            @Override
            protected String getClassName() {
                return ReferenceRenderer.this.getClassName();
            }
        };
    }
}

